/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.nef;

import it.tidalwave.imageio.raw.Directory;
import it.tidalwave.imageio.raw.TagRational;
import it.tidalwave.imageio.raw.TagRegistry;
import it.tidalwave.imageio.tiff.IFDSupport;

public class Nikon3MakerNoteSupport
extends IFDSupport {
    private static final long serialVersionUID = 1237805638960118907L;
    public static final TagRegistry REGISTRY = TagRegistry.getRegistry("Nikon3");
    public static final Object FIRMWARE_VERSION = REGISTRY.register(1, "Firmware Version");
    public static final Object ISO = REGISTRY.register(2, "ISO");
    public static final Object COLOR_MODE_CHK = REGISTRY.register(3, "Color Mode (?)");
    public static final Object QUALITY = REGISTRY.register(4, "Quality");
    public static final Object WHITE_BALANCE = REGISTRY.register(5, "White Balance");
    public static final Object SHARPENING = REGISTRY.register(6, "Sharpening");
    public static final Object FOCUS_MODE = REGISTRY.register(7, "Focus Mode");
    public static final Object FLASH_SETTING = REGISTRY.register(8, "Flash Setting");
    public static final Object AUTO_FLASH_MODE = REGISTRY.register(9, "Auto Flash Mode");
    public static final Object WHITE_BALANCE_FINE = REGISTRY.register(11, "White Balance Fine");
    public static final Object WHITE_BALANCE_RB_COEFFICIENTS = REGISTRY.register(12, "White Balance RB Coefficients");
    public static final Object TAG13 = REGISTRY.register(13, "tag13");
    public static final Object EXPOSURE_DIFFERENCE_CHK = REGISTRY.register(14, "Exposure Difference (?)");
    public static final Object ISO_SELECTION = REGISTRY.register(15, "ISO Selection");
    public static final Object DATA_DUMP = REGISTRY.register(16, "Data Dump");
    public static final Object THUMBNAIL_OFFSET = REGISTRY.register(17, "Thumbnail Offset");
    public static final Object FLASH_COMPENSATION = REGISTRY.register(18, "Flash Compensation");
    public static final Object ISO_REQUESTED = REGISTRY.register(19, "ISO Requested");
    public static final Object NDF_IMAGE_BOUNDARY = REGISTRY.register(22, "NDF Image Boundary");
    public static final Object FLASH_BRACKET_COMPENSATION_CHK = REGISTRY.register(24, "Flash Bracket Compensation (?)");
    public static final Object AE_BRACKET_COMPENSATION_CHK = REGISTRY.register(25, "AE Bracket Compensation (?)");
    public static final Object SENSOR_SIZE = REGISTRY.register(27, "Sensor Size");
    public static final Object D2X_SERIAL_NUMBER = REGISTRY.register(29, "D2X Serial Number");
    public static final Object IMAGE_ADJUSTMENT = REGISTRY.register(128, "Image Adjustment");
    public static final Object TONE_COMPENSATION = REGISTRY.register(129, "Tone Compensation");
    public static final Object LENS_ADAPTER_CHK = REGISTRY.register(130, "Lens Adapter (?)");
    public static final Object LENS_TYPE = REGISTRY.register(131, "Lens Type");
    public static final Object LENS_RANGE = REGISTRY.register(132, "Lens Range");
    public static final Object FOCUS_DISTANCE = REGISTRY.register(133, "Focus Distance");
    public static final Object DIGITAL_ZOOM = REGISTRY.register(134, "Digital Zoom");
    public static final Object FLASH_TYPE = REGISTRY.register(135, "Flash Type");
    public static final Object AF_FOCUS_POSITION = REGISTRY.register(136, "AF Focus Position");
    public static final Object BRACKETING = REGISTRY.register(137, "Bracketing");
    public static final Object LENS_F_STOP_CHK = REGISTRY.register(139, "Lens F Stop (?)");
    public static final Object CURVE = REGISTRY.register(140, "Curve");
    public static final Object COLOR_MODE = REGISTRY.register(141, "Color Mode");
    public static final Object LIGHTING_TYPE_CHK = REGISTRY.register(142, "Lighting Type (?)");
    public static final Object SCENE_MODE_CHK = REGISTRY.register(143, "Scene Mode (?)");
    public static final Object LIGHT_TYPE = REGISTRY.register(144, "Light Type");
    public static final Object HUE = REGISTRY.register(146, "Hue");
    public static final Object FLASH_UNKNOWN_INFO_CHK = REGISTRY.register(147, "Flash Unknown Info (?)");
    public static final Object SATURATION = REGISTRY.register(148, "Saturation");
    public static final Object NOISE_REDUCTION = REGISTRY.register(149, "Noise Reduction");
    public static final Object COMPRESSION_DATA = REGISTRY.register(150, "Compression Data");
    public static final Object BLOCK_151 = REGISTRY.register(151, "Block 151");
    public static final Object LENS_INFO = REGISTRY.register(152, "Lens Info");
    public static final Object BAYER_UNIT_COUNT = REGISTRY.register(153, "Bayer Unit Count");
    public static final Object SENSOR_PIXEL_SIZE = REGISTRY.register(154, "Sensor Pixel Size");
    public static final Object CAMERA_SERIAL_NUMBER = REGISTRY.register(160, "Camera Serial Number");
    public static final Object NDF_LENGTH = REGISTRY.register(162, "NDF Length");
    public static final Object SHUTTER_COUNT = REGISTRY.register(167, "Shutter Count");
    public static final Object IMAGE_OPTIMIZATION_CHK = REGISTRY.register(169, "Image Optimization (?)");
    public static final Object SATURATION_2_CHK = REGISTRY.register(170, "Saturation 2 (?)");
    public static final Object VARI_PROGRAM = REGISTRY.register(171, "Vari Program");
    public static final Object PRINT_IM_CHK = REGISTRY.register(3584, "Print IM (?)");
    public static final Object CAPTURE_EDITOR_DATA = REGISTRY.register(3585, "Capture Editor Data");
    public static final Object CAPTURE_OFFSETS_CHK = REGISTRY.register(3598, "Capture Offsets (?)");
    public static final Object TAG3600 = REGISTRY.register(3600, "tag3600");

    public Nikon3MakerNoteSupport() {
        super(REGISTRY);
    }

    public boolean isFirmwareVersionAvailable() {
        return this.containsTag(FIRMWARE_VERSION);
    }

    public byte[] getFirmwareVersion() {
        return this.getBytes(FIRMWARE_VERSION);
    }

    public boolean isISOAvailable() {
        return this.containsTag(ISO);
    }

    public int[] getISO() {
        return this.getIntegers(ISO);
    }

    public boolean isColorModeCHKAvailable() {
        return this.containsTag(COLOR_MODE_CHK);
    }

    public ColorModeCHK getColorModeCHK() {
        return ColorModeCHK.getInstance(this.getString(COLOR_MODE_CHK));
    }

    public boolean isQualityAvailable() {
        return this.containsTag(QUALITY);
    }

    public Quality getQuality() {
        return Quality.getInstance(this.getString(QUALITY));
    }

    public boolean isWhiteBalanceAvailable() {
        return this.containsTag(WHITE_BALANCE);
    }

    public WhiteBalance getWhiteBalance() {
        return WhiteBalance.getInstance(this.getString(WHITE_BALANCE));
    }

    public boolean isSharpeningAvailable() {
        return this.containsTag(SHARPENING);
    }

    public Sharpening getSharpening() {
        return Sharpening.getInstance(this.getString(SHARPENING));
    }

    public boolean isFocusModeAvailable() {
        return this.containsTag(FOCUS_MODE);
    }

    public FocusMode getFocusMode() {
        return FocusMode.getInstance(this.getString(FOCUS_MODE));
    }

    public boolean isFlashSettingAvailable() {
        return this.containsTag(FLASH_SETTING);
    }

    public FlashSetting getFlashSetting() {
        return FlashSetting.getInstance(this.getString(FLASH_SETTING));
    }

    public boolean isAutoFlashModeAvailable() {
        return this.containsTag(AUTO_FLASH_MODE);
    }

    public AutoFlashMode getAutoFlashMode() {
        return AutoFlashMode.getInstance(this.getString(AUTO_FLASH_MODE));
    }

    public boolean isWhiteBalanceFineAvailable() {
        return this.containsTag(WHITE_BALANCE_FINE);
    }

    public int getWhiteBalanceFine() {
        return this.getInteger(WHITE_BALANCE_FINE);
    }

    public boolean isWhiteBalanceRBCoefficientsAvailable() {
        return this.containsTag(WHITE_BALANCE_RB_COEFFICIENTS);
    }

    public TagRational[] getWhiteBalanceRBCoefficients() {
        return this.getRationals(WHITE_BALANCE_RB_COEFFICIENTS);
    }

    public boolean istag13Available() {
        return this.containsTag(TAG13);
    }

    public byte[] gettag13() {
        return this.getBytes(TAG13);
    }

    public boolean isExposureDifferenceCHKAvailable() {
        return this.containsTag(EXPOSURE_DIFFERENCE_CHK);
    }

    public byte[] getExposureDifferenceCHK() {
        return this.getBytes(EXPOSURE_DIFFERENCE_CHK);
    }

    public boolean isISOSelectionAvailable() {
        return this.containsTag(ISO_SELECTION);
    }

    public ISOSelection getISOSelection() {
        return ISOSelection.getInstance(this.getString(ISO_SELECTION));
    }

    public boolean isDataDumpAvailable() {
        return this.containsTag(DATA_DUMP);
    }

    public byte[] getDataDump() {
        return this.getBytes(DATA_DUMP);
    }

    public boolean isThumbnailOffsetAvailable() {
        return this.containsTag(THUMBNAIL_OFFSET);
    }

    public int getThumbnailOffset() {
        return this.getInteger(THUMBNAIL_OFFSET);
    }

    public boolean isFlashCompensationAvailable() {
        return this.containsTag(FLASH_COMPENSATION);
    }

    public byte[] getFlashCompensation() {
        return this.getBytes(FLASH_COMPENSATION);
    }

    public boolean isISORequestedAvailable() {
        return this.containsTag(ISO_REQUESTED);
    }

    public int[] getISORequested() {
        return this.getIntegers(ISO_REQUESTED);
    }

    public boolean isNDFImageBoundaryAvailable() {
        return this.containsTag(NDF_IMAGE_BOUNDARY);
    }

    public int[] getNDFImageBoundary() {
        return this.getIntegers(NDF_IMAGE_BOUNDARY);
    }

    public boolean isFlashBracketCompensationCHKAvailable() {
        return this.containsTag(FLASH_BRACKET_COMPENSATION_CHK);
    }

    public int getFlashBracketCompensationCHK() {
        return this.getInteger(FLASH_BRACKET_COMPENSATION_CHK);
    }

    public boolean isAEBracketCompensationCHKAvailable() {
        return this.containsTag(AE_BRACKET_COMPENSATION_CHK);
    }

    public int getAEBracketCompensationCHK() {
        return this.getInteger(AE_BRACKET_COMPENSATION_CHK);
    }

    public boolean isSensorSizeAvailable() {
        return this.containsTag(SENSOR_SIZE);
    }

    public int[] getSensorSize() {
        return this.getIntegers(SENSOR_SIZE);
    }

    public boolean isD2XSerialNumberAvailable() {
        return this.containsTag(D2X_SERIAL_NUMBER);
    }

    public String getD2XSerialNumber() {
        return this.getString(D2X_SERIAL_NUMBER);
    }

    public boolean isImageAdjustmentAvailable() {
        return this.containsTag(IMAGE_ADJUSTMENT);
    }

    public ImageAdjustment getImageAdjustment() {
        return ImageAdjustment.getInstance(this.getString(IMAGE_ADJUSTMENT));
    }

    public boolean isToneCompensationAvailable() {
        return this.containsTag(TONE_COMPENSATION);
    }

    public ToneCompensation getToneCompensation() {
        return ToneCompensation.getInstance(this.getString(TONE_COMPENSATION));
    }

    public boolean isLensAdapterCHKAvailable() {
        return this.containsTag(LENS_ADAPTER_CHK);
    }

    public LensAdapterCHK getLensAdapterCHK() {
        return LensAdapterCHK.getInstance(this.getString(LENS_ADAPTER_CHK));
    }

    public boolean isLensTypeAvailable() {
        return this.containsTag(LENS_TYPE);
    }

    public int getLensType() {
        return this.getByte(LENS_TYPE);
    }

    public boolean isLensRangeAvailable() {
        return this.containsTag(LENS_RANGE);
    }

    public TagRational[] getLensRange() {
        return this.getRationals(LENS_RANGE);
    }

    public boolean isFocusDistanceAvailable() {
        return this.containsTag(FOCUS_DISTANCE);
    }

    public TagRational getFocusDistance() {
        return this.getRational(FOCUS_DISTANCE);
    }

    public boolean isDigitalZoomAvailable() {
        return this.containsTag(DIGITAL_ZOOM);
    }

    public TagRational getDigitalZoom() {
        return this.getRational(DIGITAL_ZOOM);
    }

    public boolean isFlashTypeAvailable() {
        return this.containsTag(FLASH_TYPE);
    }

    public FlashType getFlashType() {
        return FlashType.getInstance(this.getByte(FLASH_TYPE));
    }

    public boolean isAFFocusPositionAvailable() {
        return this.containsTag(AF_FOCUS_POSITION);
    }

    public byte[] getAFFocusPosition() {
        return this.getBytes(AF_FOCUS_POSITION);
    }

    public boolean isBracketingAvailable() {
        return this.containsTag(BRACKETING);
    }

    public int getBracketing() {
        return this.getInteger(BRACKETING);
    }

    public boolean isLensFStopCHKAvailable() {
        return this.containsTag(LENS_F_STOP_CHK);
    }

    public byte[] getLensFStopCHK() {
        return this.getBytes(LENS_F_STOP_CHK);
    }

    public boolean isCurveAvailable() {
        return this.containsTag(CURVE);
    }

    public byte[] getCurve() {
        return this.getBytes(CURVE);
    }

    public boolean isColorModeAvailable() {
        return this.containsTag(COLOR_MODE);
    }

    public ColorMode getColorMode() {
        return ColorMode.getInstance(this.getString(COLOR_MODE));
    }

    public boolean isLightingTypeCHKAvailable() {
        return this.containsTag(LIGHTING_TYPE_CHK);
    }

    public String getLightingTypeCHK() {
        return this.getString(LIGHTING_TYPE_CHK);
    }

    public boolean isSceneModeCHKAvailable() {
        return this.containsTag(SCENE_MODE_CHK);
    }

    public String getSceneModeCHK() {
        return this.getString(SCENE_MODE_CHK);
    }

    public boolean isLightTypeAvailable() {
        return this.containsTag(LIGHT_TYPE);
    }

    public LightType getLightType() {
        return LightType.getInstance(this.getString(LIGHT_TYPE));
    }

    public boolean isHueAvailable() {
        return this.containsTag(HUE);
    }

    public int getHue() {
        return this.getInteger(HUE);
    }

    public boolean isFlashUnknownInfoCHKAvailable() {
        return this.containsTag(FLASH_UNKNOWN_INFO_CHK);
    }

    public int getFlashUnknownInfoCHK() {
        return this.getInteger(FLASH_UNKNOWN_INFO_CHK);
    }

    public boolean isSaturationAvailable() {
        return this.containsTag(SATURATION);
    }

    public int getSaturation() {
        return this.getInteger(SATURATION);
    }

    public boolean isNoiseReductionAvailable() {
        return this.containsTag(NOISE_REDUCTION);
    }

    public NoiseReduction getNoiseReduction() {
        return NoiseReduction.getInstance(this.getString(NOISE_REDUCTION));
    }

    public boolean isCompressionDataAvailable() {
        return this.containsTag(COMPRESSION_DATA);
    }

    public byte[] getCompressionData() {
        return this.getBytes(COMPRESSION_DATA);
    }

    public boolean isBlock151Available() {
        return this.containsTag(BLOCK_151);
    }

    public byte[] getBlock151() {
        return this.getBytes(BLOCK_151);
    }

    public boolean isLensInfoAvailable() {
        return this.containsTag(LENS_INFO);
    }

    public byte[] getLensInfo() {
        return this.getBytes(LENS_INFO);
    }

    public boolean isBayerUnitCountAvailable() {
        return this.containsTag(BAYER_UNIT_COUNT);
    }

    public int[] getBayerUnitCount() {
        return this.getIntegers(BAYER_UNIT_COUNT);
    }

    public boolean isSensorPixelSizeAvailable() {
        return this.containsTag(SENSOR_PIXEL_SIZE);
    }

    public TagRational[] getSensorPixelSize() {
        return this.getRationals(SENSOR_PIXEL_SIZE);
    }

    public boolean isCameraSerialNumberAvailable() {
        return this.containsTag(CAMERA_SERIAL_NUMBER);
    }

    public String getCameraSerialNumber() {
        return this.getString(CAMERA_SERIAL_NUMBER);
    }

    public boolean isNDFLengthAvailable() {
        return this.containsTag(NDF_LENGTH);
    }

    public int getNDFLength() {
        return this.getInteger(NDF_LENGTH);
    }

    public boolean isShutterCountAvailable() {
        return this.containsTag(SHUTTER_COUNT);
    }

    public int getShutterCount() {
        return this.getInteger(SHUTTER_COUNT);
    }

    public boolean isImageOptimizationCHKAvailable() {
        return this.containsTag(IMAGE_OPTIMIZATION_CHK);
    }

    public ImageOptimizationCHK getImageOptimizationCHK() {
        return ImageOptimizationCHK.getInstance(this.getString(IMAGE_OPTIMIZATION_CHK));
    }

    public boolean isSaturation2CHKAvailable() {
        return this.containsTag(SATURATION_2_CHK);
    }

    public Saturation2CHK getSaturation2CHK() {
        return Saturation2CHK.getInstance(this.getString(SATURATION_2_CHK));
    }

    public boolean isVariProgramAvailable() {
        return this.containsTag(VARI_PROGRAM);
    }

    public VariProgram getVariProgram() {
        return VariProgram.getInstance(this.getString(VARI_PROGRAM));
    }

    public boolean isPrintIMCHKAvailable() {
        return this.containsTag(PRINT_IM_CHK);
    }

    public byte[] getPrintIMCHK() {
        return this.getBytes(PRINT_IM_CHK);
    }

    public boolean isCaptureEditorDataAvailable() {
        return this.containsTag(CAPTURE_EDITOR_DATA);
    }

    public byte[] getCaptureEditorData() {
        return this.getBytes(CAPTURE_EDITOR_DATA);
    }

    public boolean isCaptureOffsetsCHKAvailable() {
        return this.containsTag(CAPTURE_OFFSETS_CHK);
    }

    public int getCaptureOffsetsCHK() {
        return this.getInteger(CAPTURE_OFFSETS_CHK);
    }

    public boolean istag3600Available() {
        return this.containsTag(TAG3600);
    }

    public int gettag3600() {
        return this.getInteger(TAG3600);
    }

    public static class VariProgram
    extends Directory.Enumeration {
        public static final VariProgram _AUTO = new VariProgram("AUTO", "AUTO");
        public static final VariProgram _CLOSE_UP = new VariProgram("CLOSE UP", "CLOSE UP");
        public static final VariProgram _LAND_SCAPE = new VariProgram("LAND SCAPE", "LAND SCAPE");
        public static final VariProgram _NIGHT_PORTRAIT = new VariProgram("NIGHT PORTRAIT", "NIGHT PORTRAIT");
        public static final VariProgram _NIGHT_SCENE = new VariProgram("NIGHT SCENE", "NIGHT SCENE");
        public static final VariProgram _PORTRAIT = new VariProgram("PORTRAIT", "PORTRAIT");
        public static final VariProgram _SPORT = new VariProgram("SPORT", "SPORT");
        public static final VariProgram _EMPTY = new VariProgram("empty", "empty");

        private VariProgram(String value, String name) {
            super(value, name);
        }

        private VariProgram(String[] value, String name) {
            super(value, name);
        }

        public static VariProgram getInstance(String value) {
            if (VariProgram.equals(value, "AUTO")) {
                return _AUTO;
            }
            if (VariProgram.equals(value, "CLOSE UP")) {
                return _CLOSE_UP;
            }
            if (VariProgram.equals(value, "LAND SCAPE")) {
                return _LAND_SCAPE;
            }
            if (VariProgram.equals(value, "NIGHT PORTRAIT")) {
                return _NIGHT_PORTRAIT;
            }
            if (VariProgram.equals(value, "NIGHT SCENE")) {
                return _NIGHT_SCENE;
            }
            if (VariProgram.equals(value, "PORTRAIT")) {
                return _PORTRAIT;
            }
            if (VariProgram.equals(value, "SPORT")) {
                return _SPORT;
            }
            if (VariProgram.equals(value, "empty")) {
                return _EMPTY;
            }
            return new VariProgram(value, "unknown");
        }
    }

    public static class Saturation2CHK
    extends Directory.Enumeration {
        public static final Saturation2CHK _ENHANCED = new Saturation2CHK("ENHANCED", "ENHANCED");
        public static final Saturation2CHK _MODERATE = new Saturation2CHK("MODERATE", "MODERATE");
        public static final Saturation2CHK _NORMAL = new Saturation2CHK("NORMAL", "NORMAL");

        private Saturation2CHK(String value, String name) {
            super(value, name);
        }

        private Saturation2CHK(String[] value, String name) {
            super(value, name);
        }

        public static Saturation2CHK getInstance(String value) {
            if (Saturation2CHK.equals(value, "ENHANCED")) {
                return _ENHANCED;
            }
            if (Saturation2CHK.equals(value, "MODERATE")) {
                return _MODERATE;
            }
            if (Saturation2CHK.equals(value, "NORMAL")) {
                return _NORMAL;
            }
            return new Saturation2CHK(value, "unknown");
        }
    }

    public static class ImageOptimizationCHK
    extends Directory.Enumeration {
        public static final ImageOptimizationCHK _CUSTOM = new ImageOptimizationCHK("CUSTOM", "CUSTOM");
        public static final ImageOptimizationCHK _NORMAL = new ImageOptimizationCHK("NORMAL", "NORMAL");
        public static final ImageOptimizationCHK _EMPTY = new ImageOptimizationCHK("empty", "empty");

        private ImageOptimizationCHK(String value, String name) {
            super(value, name);
        }

        private ImageOptimizationCHK(String[] value, String name) {
            super(value, name);
        }

        public static ImageOptimizationCHK getInstance(String value) {
            if (ImageOptimizationCHK.equals(value, "CUSTOM")) {
                return _CUSTOM;
            }
            if (ImageOptimizationCHK.equals(value, "NORMAL")) {
                return _NORMAL;
            }
            if (ImageOptimizationCHK.equals(value, "empty")) {
                return _EMPTY;
            }
            return new ImageOptimizationCHK(value, "unknown");
        }
    }

    public static class NoiseReduction
    extends Directory.Enumeration {
        public static final NoiseReduction _FPNR = new NoiseReduction("FPNR", "FPNR");
        public static final NoiseReduction _OFF = new NoiseReduction("OFF", "OFF");

        private NoiseReduction(String value, String name) {
            super(value, name);
        }

        private NoiseReduction(String[] value, String name) {
            super(value, name);
        }

        public static NoiseReduction getInstance(String value) {
            if (NoiseReduction.equals(value, "FPNR")) {
                return _FPNR;
            }
            if (NoiseReduction.equals(value, "OFF")) {
                return _OFF;
            }
            return new NoiseReduction(value, "unknown");
        }
    }

    public static class LightType
    extends Directory.Enumeration {
        public static final LightType _COLORED = new LightType("COLORED", "COLORED");
        public static final LightType _MIXED = new LightType("MIXED", "MIXED");
        public static final LightType _NATURAL = new LightType("NATURAL", "NATURAL");
        public static final LightType _NORMAL = new LightType("NORMAL", "NORMAL");
        public static final LightType _SPEEDLIGHT = new LightType("SPEEDLIGHT", "SPEEDLIGHT");

        private LightType(String value, String name) {
            super(value, name);
        }

        private LightType(String[] value, String name) {
            super(value, name);
        }

        public static LightType getInstance(String value) {
            if (LightType.equals(value, "COLORED")) {
                return _COLORED;
            }
            if (LightType.equals(value, "MIXED")) {
                return _MIXED;
            }
            if (LightType.equals(value, "NATURAL")) {
                return _NATURAL;
            }
            if (LightType.equals(value, "NORMAL")) {
                return _NORMAL;
            }
            if (LightType.equals(value, "SPEEDLIGHT")) {
                return _SPEEDLIGHT;
            }
            return new LightType(value, "unknown");
        }
    }

    public static class ColorMode
    extends Directory.Enumeration {
        public static final ColorMode _MODE1 = new ColorMode("MODE1", "MODE1");
        public static final ColorMode _MODE1A = new ColorMode("MODE1a", "MODE1a");
        public static final ColorMode _MODE2 = new ColorMode("MODE2", "MODE2");
        public static final ColorMode _MODE3 = new ColorMode("MODE3", "MODE3");
        public static final ColorMode _MODE3A = new ColorMode("MODE3a", "MODE3a");

        private ColorMode(String value, String name) {
            super(value, name);
        }

        private ColorMode(String[] value, String name) {
            super(value, name);
        }

        public static ColorMode getInstance(String value) {
            if (ColorMode.equals(value, "MODE1")) {
                return _MODE1;
            }
            if (ColorMode.equals(value, "MODE1a")) {
                return _MODE1A;
            }
            if (ColorMode.equals(value, "MODE2")) {
                return _MODE2;
            }
            if (ColorMode.equals(value, "MODE3")) {
                return _MODE3;
            }
            if (ColorMode.equals(value, "MODE3a")) {
                return _MODE3A;
            }
            return new ColorMode(value, "unknown");
        }
    }

    public static class FlashType
    extends Directory.Enumeration {
        public static final FlashType _0 = new FlashType(0, "0");
        public static final FlashType _3 = new FlashType(3, "3");
        public static final FlashType _4 = new FlashType(4, "4");
        public static final FlashType _7 = new FlashType(7, "7");
        public static final FlashType _8 = new FlashType(8, "8");
        public static final FlashType _9 = new FlashType(9, "9");

        private FlashType(int value, String name) {
            super(value, name);
        }

        private FlashType(int[] value, String name) {
            super(value, name);
        }

        public static FlashType getInstance(int value) {
            if (FlashType.equals(value, 0)) {
                return _0;
            }
            if (FlashType.equals(value, 3)) {
                return _3;
            }
            if (FlashType.equals(value, 4)) {
                return _4;
            }
            if (FlashType.equals(value, 7)) {
                return _7;
            }
            if (FlashType.equals(value, 8)) {
                return _8;
            }
            if (FlashType.equals(value, 9)) {
                return _9;
            }
            return new FlashType(value, "unknown");
        }
    }

    public static class LensAdapterCHK
    extends Directory.Enumeration {
        public static final LensAdapterCHK _OFF = new LensAdapterCHK("OFF", "OFF");

        private LensAdapterCHK(String value, String name) {
            super(value, name);
        }

        private LensAdapterCHK(String[] value, String name) {
            super(value, name);
        }

        public static LensAdapterCHK getInstance(String value) {
            if (LensAdapterCHK.equals(value, "OFF")) {
                return _OFF;
            }
            return new LensAdapterCHK(value, "unknown");
        }
    }

    public static class ToneCompensation
    extends Directory.Enumeration {
        public static final ToneCompensation _AUTO = new ToneCompensation("AUTO", "AUTO");
        public static final ToneCompensation _CS = new ToneCompensation("CS", "CS");
        public static final ToneCompensation _HIGH = new ToneCompensation("HIGH", "HIGH");
        public static final ToneCompensation _LOW = new ToneCompensation("LOW", "LOW");
        public static final ToneCompensation _NORMAL = new ToneCompensation("NORMAL", "NORMAL");

        private ToneCompensation(String value, String name) {
            super(value, name);
        }

        private ToneCompensation(String[] value, String name) {
            super(value, name);
        }

        public static ToneCompensation getInstance(String value) {
            if (ToneCompensation.equals(value, "AUTO")) {
                return _AUTO;
            }
            if (ToneCompensation.equals(value, "CS")) {
                return _CS;
            }
            if (ToneCompensation.equals(value, "HIGH")) {
                return _HIGH;
            }
            if (ToneCompensation.equals(value, "LOW")) {
                return _LOW;
            }
            if (ToneCompensation.equals(value, "NORMAL")) {
                return _NORMAL;
            }
            return new ToneCompensation(value, "unknown");
        }
    }

    public static class ImageAdjustment
    extends Directory.Enumeration {
        public static final ImageAdjustment _AUTO = new ImageAdjustment("AUTO", "AUTO");
        public static final ImageAdjustment _NORMAL = new ImageAdjustment("NORMAL", "NORMAL");

        private ImageAdjustment(String value, String name) {
            super(value, name);
        }

        private ImageAdjustment(String[] value, String name) {
            super(value, name);
        }

        public static ImageAdjustment getInstance(String value) {
            if (ImageAdjustment.equals(value, "AUTO")) {
                return _AUTO;
            }
            if (ImageAdjustment.equals(value, "NORMAL")) {
                return _NORMAL;
            }
            return new ImageAdjustment(value, "unknown");
        }
    }

    public static class ISOSelection
    extends Directory.Enumeration {
        public static final ISOSelection _AUTO = new ISOSelection("AUTO", "AUTO");
        public static final ISOSelection _MANUAL = new ISOSelection("MANUAL", "MANUAL");

        private ISOSelection(String value, String name) {
            super(value, name);
        }

        private ISOSelection(String[] value, String name) {
            super(value, name);
        }

        public static ISOSelection getInstance(String value) {
            if (ISOSelection.equals(value, "AUTO")) {
                return _AUTO;
            }
            if (ISOSelection.equals(value, "MANUAL")) {
                return _MANUAL;
            }
            return new ISOSelection(value, "unknown");
        }
    }

    public static class AutoFlashMode
    extends Directory.Enumeration {
        public static final AutoFlashMode _COMDR__M = new AutoFlashMode("Comdr.,M", "Comdr.,M");
        public static final AutoFlashMode _NEW_TTL = new AutoFlashMode("NEW_TTL", "NEW_TTL");
        public static final AutoFlashMode _OPTIONAL_TTL = new AutoFlashMode("Optional,TTL", "Optional,TTL");
        public static final AutoFlashMode _EMPTY = new AutoFlashMode("empty", "empty");

        private AutoFlashMode(String value, String name) {
            super(value, name);
        }

        private AutoFlashMode(String[] value, String name) {
            super(value, name);
        }

        public static AutoFlashMode getInstance(String value) {
            if (AutoFlashMode.equals(value, "Comdr.,M")) {
                return _COMDR__M;
            }
            if (AutoFlashMode.equals(value, "NEW_TTL")) {
                return _NEW_TTL;
            }
            if (AutoFlashMode.equals(value, "Optional,TTL")) {
                return _OPTIONAL_TTL;
            }
            if (AutoFlashMode.equals(value, "empty")) {
                return _EMPTY;
            }
            return new AutoFlashMode(value, "unknown");
        }
    }

    public static class FlashSetting
    extends Directory.Enumeration {
        public static final FlashSetting _NORMAL = new FlashSetting("NORMAL", "NORMAL");
        public static final FlashSetting _REAR = new FlashSetting("REAR", "REAR");
        public static final FlashSetting _REAR_SLOW = new FlashSetting("REAR SLOW", "REAR SLOW");
        public static final FlashSetting _RED_EYE = new FlashSetting("RED-EYE", "RED-EYE");
        public static final FlashSetting _SLOW = new FlashSetting("SLOW", "SLOW");
        public static final FlashSetting _EMPTY = new FlashSetting("empty", "empty");

        private FlashSetting(String value, String name) {
            super(value, name);
        }

        private FlashSetting(String[] value, String name) {
            super(value, name);
        }

        public static FlashSetting getInstance(String value) {
            if (FlashSetting.equals(value, "NORMAL")) {
                return _NORMAL;
            }
            if (FlashSetting.equals(value, "REAR")) {
                return _REAR;
            }
            if (FlashSetting.equals(value, "REAR SLOW")) {
                return _REAR_SLOW;
            }
            if (FlashSetting.equals(value, "RED-EYE")) {
                return _RED_EYE;
            }
            if (FlashSetting.equals(value, "SLOW")) {
                return _SLOW;
            }
            if (FlashSetting.equals(value, "empty")) {
                return _EMPTY;
            }
            return new FlashSetting(value, "unknown");
        }
    }

    public static class FocusMode
    extends Directory.Enumeration {
        public static final FocusMode _AF_A = new FocusMode("AF-A", "AF-A");
        public static final FocusMode _AF_C = new FocusMode("AF-C", "AF-C");
        public static final FocusMode _AF_S = new FocusMode("AF-S", "AF-S");
        public static final FocusMode _MANUAL = new FocusMode("MANUAL", "MANUAL");

        private FocusMode(String value, String name) {
            super(value, name);
        }

        private FocusMode(String[] value, String name) {
            super(value, name);
        }

        public static FocusMode getInstance(String value) {
            if (FocusMode.equals(value, "AF-A")) {
                return _AF_A;
            }
            if (FocusMode.equals(value, "AF-C")) {
                return _AF_C;
            }
            if (FocusMode.equals(value, "AF-S")) {
                return _AF_S;
            }
            if (FocusMode.equals(value, "MANUAL")) {
                return _MANUAL;
            }
            return new FocusMode(value, "unknown");
        }
    }

    public static class Sharpening
    extends Directory.Enumeration {
        public static final Sharpening _AUTO = new Sharpening("AUTO", "AUTO");
        public static final Sharpening _HIGH = new Sharpening("HIGH", "HIGH");
        public static final Sharpening _LOW = new Sharpening("LOW", "LOW");
        public static final Sharpening _MED_H = new Sharpening("MED.H", "MED.H");
        public static final Sharpening _MED_L = new Sharpening("MED.L", "MED.L");
        public static final Sharpening _NONE = new Sharpening("NONE", "NONE");
        public static final Sharpening _NORMAL = new Sharpening("NORMAL", "NORMAL");
        public static final Sharpening _EMPTY = new Sharpening("empty", "empty");

        private Sharpening(String value, String name) {
            super(value, name);
        }

        private Sharpening(String[] value, String name) {
            super(value, name);
        }

        public static Sharpening getInstance(String value) {
            if (Sharpening.equals(value, "AUTO")) {
                return _AUTO;
            }
            if (Sharpening.equals(value, "HIGH")) {
                return _HIGH;
            }
            if (Sharpening.equals(value, "LOW")) {
                return _LOW;
            }
            if (Sharpening.equals(value, "MED.H")) {
                return _MED_H;
            }
            if (Sharpening.equals(value, "MED.L")) {
                return _MED_L;
            }
            if (Sharpening.equals(value, "NONE")) {
                return _NONE;
            }
            if (Sharpening.equals(value, "NORMAL")) {
                return _NORMAL;
            }
            if (Sharpening.equals(value, "empty")) {
                return _EMPTY;
            }
            return new Sharpening(value, "unknown");
        }
    }

    public static class WhiteBalance
    extends Directory.Enumeration {
        public static final WhiteBalance _AUTO = new WhiteBalance("AUTO", "AUTO");
        public static final WhiteBalance _CLOUDY = new WhiteBalance("CLOUDY", "CLOUDY");
        public static final WhiteBalance _FLASH = new WhiteBalance("FLASH", "FLASH");
        public static final WhiteBalance _INCANDESCENT = new WhiteBalance("INCANDESCENT", "INCANDESCENT");
        public static final WhiteBalance _PRESET = new WhiteBalance("PRESET", "PRESET");
        public static final WhiteBalance _PRESET1 = new WhiteBalance("PRESET1", "PRESET1");
        public static final WhiteBalance _SUNNY = new WhiteBalance("SUNNY", "SUNNY");
        public static final WhiteBalance _WHITE_PRESET = new WhiteBalance("WHITE PRESET", "WHITE PRESET");

        private WhiteBalance(String value, String name) {
            super(value, name);
        }

        private WhiteBalance(String[] value, String name) {
            super(value, name);
        }

        public static WhiteBalance getInstance(String value) {
            if (WhiteBalance.equals(value, "AUTO")) {
                return _AUTO;
            }
            if (WhiteBalance.equals(value, "CLOUDY")) {
                return _CLOUDY;
            }
            if (WhiteBalance.equals(value, "FLASH")) {
                return _FLASH;
            }
            if (WhiteBalance.equals(value, "INCANDESCENT")) {
                return _INCANDESCENT;
            }
            if (WhiteBalance.equals(value, "PRESET")) {
                return _PRESET;
            }
            if (WhiteBalance.equals(value, "PRESET1")) {
                return _PRESET1;
            }
            if (WhiteBalance.equals(value, "SUNNY")) {
                return _SUNNY;
            }
            if (WhiteBalance.equals(value, "WHITE PRESET")) {
                return _WHITE_PRESET;
            }
            return new WhiteBalance(value, "unknown");
        }
    }

    public static class Quality
    extends Directory.Enumeration {
        public static final Quality _RAW = new Quality("RAW", "RAW");
        public static final Quality _RAW2_7M = new Quality("RAW2.7M", "RAW2.7M");

        private Quality(String value, String name) {
            super(value, name);
        }

        private Quality(String[] value, String name) {
            super(value, name);
        }

        public static Quality getInstance(String value) {
            if (Quality.equals(value, "RAW")) {
                return _RAW;
            }
            if (Quality.equals(value, "RAW2.7M")) {
                return _RAW2_7M;
            }
            return new Quality(value, "unknown");
        }
    }

    public static class ColorModeCHK
    extends Directory.Enumeration {
        public static final ColorModeCHK _COLOR = new ColorModeCHK("COLOR", "COLOR");

        private ColorModeCHK(String value, String name) {
            super(value, name);
        }

        private ColorModeCHK(String[] value, String name) {
            super(value, name);
        }

        public static ColorModeCHK getInstance(String value) {
            if (ColorModeCHK.equals(value, "COLOR")) {
                return _COLOR;
            }
            return new ColorModeCHK(value, "unknown");
        }
    }
}

