/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.nef;

import it.tidalwave.imageio.util.Logger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class NikonCaptureEditorMetadata {
    private static final String CLASS = "it.tidalwave.imageio.rawprocessor.nef.NikonCaptureEditorMetadata";
    private static final Logger logger = Logger.getLogger("it.tidalwave.imageio.rawprocessor.nef.NikonCaptureEditorMetadata");
    private static final int NOISE_REDUCTION_MARKER = 1966984128;
    private static final int NOISE_REDUCTION_DATA_MARKER = -1838214176;
    private static final int WHITE_BALANCE_MARKER = 1990472196;
    private static final int WHITE_BALANCE_DATA_MARKER = -1086559200;
    private static final int ADVANCED_RAW_MARKER = 1990472195;
    private static final int ADVANCED_RAW_DATA_MARKER = 1453671008;
    private static final int COLOR_BOOSTER_MARKER = 1594785059;
    private static final int COLOR_BOOSTER_DATA_MARKER = -1181113489;
    private static final int UNSHARP_MASK_MARKER = 1990472192;
    private static final int UNSHARP_MASK_DATA_MARKER = -466923167;
    private static final int CROP_MARKER = 927085536;
    private static final int ORIENTATION_MARKER = 1990472199;
    private static final int VIGNETTE_MARKER = 1990472197;
    private static final int COLOR_BALANCE_MARKER = 1990472194;
    private static final int CURVES_MARKER = 1990472193;
    private static final int DUST_REFERENCE_MARKER = -128813699;
    private static final int PHOTO_EFFECTS_MARKER = -1419851170;
    private static final int PHOTO_EFFECTS_DATA_MARKER = -1338487266;
    private static Map colorModeMap = new HashMap();
    private static Map hueMap = new HashMap();
    private static Map sharpeningMap = new HashMap();
    private static Map white1Map = new HashMap();
    private static Map white2Map = new HashMap();
    private static Map toneCompMap = new HashMap();
    private static Map colorBoosterMap = new HashMap();
    private static Map moireReductionMap = new HashMap();
    private static Map photoEffectMap = new HashMap();
    private static Map unsharpMaskMap = new HashMap();
    private static Map markerMap = new HashMap();
    public static final int ORIENTATION_0 = 0;
    public static final int ORIENTATION_CW90 = 90;
    public static final int ORIENTATION_CCW90 = 270;
    public static final int ORIENTATION_180 = 180;
    private static final int ORIENTATION_ORIENTATION_OFFSET = 0;
    private static final int CROP_LEFT_OFFSET = 30;
    private static final int CROP_TOP_OFFSET = 38;
    private static final int CROP_RIGHT_OFFSET = 46;
    private static final int CROP_BOTTOM_OFFSET = 54;
    private static final int ADVANCED_RAW_ENABLED_OFFSET = 0;
    private static final int ADVANCED_RAW_EV_OVERRIDE_OFFSET = 0;
    private static final int ADVANCED_RAW_CONTRAST_OFFSET = 2;
    private static final int ADVANCED_RAW_COLOR_MODE_OFFSET = 4;
    private static final int ADVANCED_RAW_HUE_CORRECTION_ENABLED_OFFSET = 6;
    private static final int ADVANCED_RAW_HUE_CORRECTION_OFFSET = 7;
    private static final int ADVANCED_RAW_SATURATION_ENABLED_OFFSET = 13;
    private static final int ADVANCED_RAW_SATURATION_COMPENSATION_OFFSET = 14;
    private static final int ADVANCED_RAW_SHARPENING_OFFSET = 15;
    public static final int ADVANCED_RAW_TONECOMP_UNCHANGED_CONTRAST = 0;
    public static final int ADVANCED_RAW_TONECOMP_NORMAL_CONTRAST = 1;
    public static final int ADVANCED_RAW_TONECOMP_LOW_CONTRAST = 2;
    public static final int ADVANCED_RAW_TONECOMP_HIGH_CONTRAST = 3;
    public static final int ADVANCED_RAW_TONECOMP_USER_DEFINED_CURVE = 4;
    public static final int ADVANCED_RAW_TONECOMP_MEDIUM_LOW_CONTRAST = 5;
    public static final int ADVANCED_RAW_TONECOMP_MEDIUM_HIGH_CONTRAST = 6;
    public static final int ADVANCED_RAW_COLOR_MODE_UNCHANGED = 0;
    public static final int ADVANCED_RAW_COLOR_MODE_I = 1;
    public static final int ADVANCED_RAW_COLOR_MODE_II = 2;
    public static final int ADVANCED_RAW_COLOR_MODE_III = 4;
    public static final int ADVANCED_RAW_HUE_MINUS_9 = 0;
    public static final int ADVANCED_RAW_HUE_MINUS_6 = 1;
    public static final int ADVANCED_RAW_HUE_MINUS_3 = 2;
    public static final int ADVANCED_RAW_HUE_ZERO = 3;
    public static final int ADVANCED_RAW_HUE_PLUS_3 = 4;
    public static final int ADVANCED_RAW_HUE_PLUS_6 = 5;
    public static final int ADVANCED_RAW_HUE_PLUS_9 = 6;
    public static final int ADVANCED_RAW_SHARPENING_UNCHANGED = 0;
    public static final int ADVANCED_RAW_SHARPENING_NONE = 1;
    public static final int ADVANCED_RAW_SHARPENING_LOW = 2;
    public static final int ADVANCED_RAW_SHARPENING_NORMAL = 3;
    public static final int ADVANCED_RAW_SHARPENING_HIGH = 4;
    public static final int WHITE_BALANCE_USE_GRAY_POINT = 1;
    public static final int WHITE_BALANCE_RECORDED_VALUE = 2;
    public static final int WHITE_BALANCE_SET_TEMPERATURE = 3;
    public static final int WHITE_BALANCE_CALCULATE_AUTOMATICALLY = 4;
    public static final int WHITE_BALANCE_DAYLIGHT_DIRECT_SUNLIGHT = 512;
    public static final int WHITE_BALANCE_DAYLIGHT_CLOUDY = 514;
    public static final int WHITE_BALANCE_DAYLIGHT_SHADE = 513;
    public static final int WHITE_BALANCE_STANDARD_FLUO_WARM_WHITE = 768;
    public static final int WHITE_BALANCE_STANDARD_FLUO_3700K = 769;
    public static final int WHITE_BALANCE_STANDARD_FLUO_COOL_WHITE = 770;
    public static final int WHITE_BALANCE_STANDARD_FLUO_5000K = 771;
    public static final int WHITE_BALANCE_STANDARD_FLUO_DAYLIGHT = 772;
    public static final int WHITE_BALANCE_HICOLOR_FLUO_WARM_WHITE = 1024;
    public static final int WHITE_BALANCE_HICOLOR_FLUO_3700K = 1025;
    public static final int WHITE_BALANCE_HICOLOR_FLUO_COOL_WHITE = 1026;
    public static final int WHITE_BALANCE_HICOLOR_FLUO_5000K = 1027;
    public static final int WHITE_BALANCE_HICOLOR_FLUO_DAYLIGHT = 1028;
    public static final int WHITE_BALANCE_FLASH = 1280;
    private static final int WHITE_BALANCE_INCANDESCENT = 256;
    private static final int WHITE_BALANCE_ENABLED_OFFSET = 0;
    private static final int WHITE_BALANCE_RED_COEFF_OFFSET = 0;
    private static final int WHITE_BALANCE_BLUE_COEFF_OFFSET = 8;
    private static final int WHITE_BALANCE_WHITEPOINT_OFFSET = 16;
    private static final int WHITE_BALANCE_WHITEPOINT_FINE_OFFSET = 20;
    private static final int WHITE_BALANCE_TEMPERATURE_OFFSET = 24;
    private static final int COLOR_BOOSTER_ENABLED_OFFSET = 0;
    private static final int COLOR_BOOSTER_TYPE_OFFSET = 0;
    private static final int COLOR_BOOSTER_LEVEL_OFFSET = 1;
    public static final int COLOR_BOOSTER_NATURE = 0;
    public static final int COLOR_BOOSTER_PEOPLE = 1;
    private static final int NOISE_REDUCTION_ENABLED_OFFSET = 0;
    private static final int NOISE_REDUCTION_OFFSET = 0;
    private static final int NOISE_REDUCTION_EDGE_OFFSET = 4;
    private static final int NOISE_REDUCTION_MOIRE_OFFSET = 5;
    public static final int NOISE_REDUCTION_MOIRE_OFF = 0;
    public static final int NOISE_REDUCTION_MOIRE_LOW = 1;
    public static final int NOISE_REDUCTION_MOIRE_MEDIUM = 2;
    public static final int NOISE_REDUCTION_MOIRE_HIGH = 3;
    private static final int PHOTO_EFFECTS_EFFECT_OFFSET = 0;
    private static final int PHOTO_EFFECTS_CYAN_RED_BALANCE_OFFSET = 4;
    private static final int PHOTO_EFFECTS_MAGENTA_GREEN_BALANCE_OFFSET = 6;
    private static final int PHOTO_EFFECTS_YELLOW_BLUE_BALANCE_OFFSET = 8;
    public static final int PHOTO_EFFECT_NONE = 0;
    public static final int PHOTO_EFFECT_BW = 1;
    public static final int PHOTO_EFFECT_SEPIA = 2;
    public static final int PHOTO_EFFECT_TINTED = 3;
    private static final int UNSHARP_MASK_TYPE_OFFSET = 19;
    private static final int UNSHARP_MASK_INTENSITY_OFFSET = 23;
    private static final int UNSHARP_MASK_HALO_WIDTH_OFFSET = 25;
    private static final int UNSHARP_MASK_THRESHOLD_OFFSET = 27;
    private static final int UNSHARP_MASK_DELTA = 27;
    private ByteBuffer byteBuffer;
    private ByteBuffer noiseReductionBuffer;
    private ByteBuffer noiseReductionDataBuffer;
    private ByteBuffer advancedRawBuffer;
    private ByteBuffer advancedRawDataBuffer;
    private ByteBuffer whiteBalanceBuffer;
    private ByteBuffer whiteBalanceDataBuffer;
    private ByteBuffer colorBoosterBuffer;
    private ByteBuffer colorBoosterDataBuffer;
    private ByteBuffer unsharpMaskBuffer;
    private ByteBuffer unsharpMaskDataBuffer;
    private ByteBuffer cropBuffer;
    private ByteBuffer orientationBuffer;
    private ByteBuffer curvesBuffer;
    private ByteBuffer colorBalanceBuffer;
    private ByteBuffer vignetteBuffer;
    private ByteBuffer photoEffectBuffer;
    private ByteBuffer photoEffectDataBuffer;
    private Map bufferMapById = new HashMap();

    public NikonCaptureEditorMetadata(byte[] buffer) {
        logger.finer("Creating a CaptureEditorMetadata from %d bytes", buffer.length);
        this.byteBuffer = ByteBuffer.allocate(buffer.length);
        this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.byteBuffer.put(buffer);
        int offset = 22;
        ArrayList temp = new ArrayList();
        block20: while (offset + 24 < this.byteBuffer.limit()) {
            int id = this.byteBuffer.getInt(offset);
            int size = (int)this.byteBuffer.getLong(offset + 18) - 4;
            this.byteBuffer.position(offset += 22);
            ByteBuffer subBuffer = this.byteBuffer.slice();
            subBuffer.order(this.byteBuffer.order());
            subBuffer.limit(size);
            this.bufferMapById.put(new Integer(id), subBuffer);
            offset += size;
            int index = temp.size() - 1;
            String s = "";
            if (logger.isLoggable(Level.FINER)) {
                s = this.getDebugString(offset, id, size, subBuffer, index);
            }
            switch (id) {
                case 1990472192: {
                    this.unsharpMaskBuffer = subBuffer;
                    logger.finer(">>>> UNSHARP MASK: %s", s);
                    continue block20;
                }
                case -466923167: {
                    this.unsharpMaskDataBuffer = subBuffer;
                    logger.finer(">>>> UNSHARP MASK DATA: %s", s);
                    continue block20;
                }
                case 1990472193: {
                    this.curvesBuffer = subBuffer;
                    logger.finer(">>>> CURVES: %s", s);
                    continue block20;
                }
                case 1990472194: {
                    this.colorBalanceBuffer = subBuffer;
                    logger.finer(">>>> COLOR BALANCE: %s", s);
                    continue block20;
                }
                case 1990472195: {
                    this.advancedRawBuffer = subBuffer;
                    logger.finer(">>>> ADVANCED RAW: %s", s);
                    continue block20;
                }
                case 1453671008: {
                    this.advancedRawDataBuffer = subBuffer;
                    logger.finer(">>>> ADVANCED RAW DATA: %s", s);
                    continue block20;
                }
                case 1990472196: {
                    this.whiteBalanceBuffer = subBuffer;
                    logger.finer(">>>> WHITE BALANCE: %s", s);
                    continue block20;
                }
                case -1086559200: {
                    this.whiteBalanceDataBuffer = subBuffer;
                    logger.finer(">>>> WHITE BALANCE DATA: %s", s);
                    continue block20;
                }
                case 1990472197: {
                    this.vignetteBuffer = subBuffer;
                    logger.finer(">>>> VIGNETTE: %s", s);
                    continue block20;
                }
                case 1990472199: {
                    this.orientationBuffer = subBuffer;
                    logger.finer(">>>> ORIENTATION: %s", s);
                    continue block20;
                }
                case 927085536: {
                    this.cropBuffer = subBuffer;
                    logger.finer(">>>> CROP: " + s, new Object[0]);
                    continue block20;
                }
                case 1966984128: {
                    this.noiseReductionBuffer = subBuffer;
                    logger.finer(">>>> NOISE REDUCTION: %s", s);
                    continue block20;
                }
                case -1838214176: {
                    this.noiseReductionDataBuffer = subBuffer;
                    logger.finer(">>>> NOISE REDUCTION DATA: %s", s);
                    continue block20;
                }
                case 1594785059: {
                    this.colorBoosterBuffer = subBuffer;
                    logger.finer(">>>> COLOR BOOSTER: %s", s);
                    continue block20;
                }
                case -1181113489: {
                    this.colorBoosterDataBuffer = subBuffer;
                    logger.finer(">>>> COLOR BOOSTER DATA: %s", s);
                    continue block20;
                }
                case -128813699: {
                    logger.finer(">>>> DUST REFERENCE: %s", s);
                    continue block20;
                }
                case -1419851170: {
                    this.photoEffectBuffer = subBuffer;
                    logger.finer(">>>> PHOTO EFFECTS: %s", s);
                    continue block20;
                }
                case -1338487266: {
                    this.photoEffectDataBuffer = subBuffer;
                    logger.finer(">>>> PHOTO EFFECTS DATA: %s", s);
                    continue block20;
                }
            }
            logger.finer(">>>> UNKNOWN: " + s, new Object[0]);
        }
        logger.finer(">>>> %s", this.toString());
    }

    public ByteBuffer getBuffer(Integer id) {
        return (ByteBuffer)this.bufferMapById.get(id);
    }

    public static String getBufferName(Integer id) {
        return NikonCaptureEditorMetadata.getConstant(markerMap, id);
    }

    public Set bufferIdSet() {
        return Collections.unmodifiableSet(this.bufferMapById.keySet());
    }

    public int getOrientation() {
        return this.orientationBuffer.getShort(0);
    }

    public double getCropLeft() {
        return this.cropBuffer.getDouble(30);
    }

    public double getCropTop() {
        return this.cropBuffer.getDouble(38);
    }

    public double getCropWidth() {
        return this.cropBuffer.getDouble(46);
    }

    public double getCropHeight() {
        return this.cropBuffer.getDouble(54);
    }

    public boolean isAdvancedRawEnabled() {
        return this.advancedRawBuffer != null && this.advancedRawBuffer.get(0) != 0;
    }

    public int getEVCompensation() {
        return this.advancedRawDataBuffer.getShort(0);
    }

    public int getToneCompensation() {
        return this.advancedRawDataBuffer.getShort(2);
    }

    public int getColorMode() {
        return this.advancedRawDataBuffer.getShort(4);
    }

    public boolean isHueCorrectionEnabled() {
        return this.advancedRawDataBuffer.get(6) != 0;
    }

    public int getHueCorrection() {
        return this.advancedRawDataBuffer.get(7);
    }

    public boolean isSaturationCompensationEnabled() {
        return this.advancedRawDataBuffer.get(13) != 0;
    }

    public int getSaturationCompensation() {
        return this.advancedRawDataBuffer.get(14);
    }

    public int getSharpening() {
        return this.advancedRawDataBuffer.get(15);
    }

    public boolean isWhiteBalanceEnabled() {
        return this.whiteBalanceBuffer != null && this.whiteBalanceBuffer.get(0) == 1;
    }

    public double getWhiteBalanceRedCoeff() {
        return this.whiteBalanceDataBuffer.getDouble(0);
    }

    public double getWhiteBalanceBlueCoeff() {
        return this.whiteBalanceDataBuffer.getDouble(8);
    }

    public int getWhiteBalanceWhitePoint() {
        return this.whiteBalanceDataBuffer.getInt(16);
    }

    public int getWhiteBalanceWhitePointFine() {
        return this.whiteBalanceDataBuffer.getInt(20);
    }

    public int getWhiteBalanceTemperature() {
        return this.whiteBalanceDataBuffer.getInt(24);
    }

    public boolean isColorBoosterEnabled() {
        return this.colorBoosterBuffer != null && this.colorBoosterBuffer.get(0) == 1;
    }

    public int getColorBoosterType() {
        return this.colorBoosterDataBuffer.get(0);
    }

    public int getColorBoosterLevel() {
        return this.colorBoosterDataBuffer.getInt(1);
    }

    public boolean isNoiseReductionEnabled() {
        return this.noiseReductionBuffer != null && this.noiseReductionBuffer.get(0) == 1;
    }

    public int getNoiseReduction() {
        return this.noiseReductionDataBuffer.getInt(0);
    }

    public boolean isEdgeNoiseReductionEnabled() {
        return this.noiseReductionDataBuffer.limit() > 4 && this.noiseReductionDataBuffer.get(4) == 1;
    }

    public int getMoireReduction() {
        return this.noiseReductionDataBuffer.limit() > 5 ? this.noiseReductionDataBuffer.getInt(5) : 0;
    }

    public boolean isPhotoEffectEnabled() {
        return this.photoEffectBuffer != null && this.photoEffectDataBuffer != null && this.photoEffectBuffer.get(0) == 1;
    }

    public int getPhotoEffect() {
        return this.photoEffectDataBuffer.getShort(0);
    }

    public int getCyanRedBalance() {
        return this.photoEffectDataBuffer.getShort(4);
    }

    public int getMagentaGreenBalance() {
        return this.photoEffectDataBuffer.getShort(6);
    }

    public int getYellowBlueBalance() {
        return this.photoEffectDataBuffer.getShort(8);
    }

    public boolean isUnsharpMaskEnabled() {
        return this.getUnsharpMaskData() != null;
    }

    public UnsharpMaskData[] getUnsharpMaskData() {
        if (this.unsharpMaskDataBuffer.limit() < 19) {
            return null;
        }
        int count = 1 + (this.unsharpMaskDataBuffer.limit() - 19) / 27;
        UnsharpMaskData[] unsharpMaskData = new UnsharpMaskData[count];
        for (int i = 0; i < count; ++i) {
            byte type = this.unsharpMaskDataBuffer.get(19 + 27 * i);
            short intensity = this.unsharpMaskDataBuffer.getShort(23 + 27 * i);
            short haloWidth = this.unsharpMaskDataBuffer.getShort(25 + 27 * i);
            int threshold = this.unsharpMaskDataBuffer.get(27 + 27 * i) & 0xFF;
            unsharpMaskData[i] = new UnsharpMaskData(type, intensity, haloWidth, threshold);
        }
        return unsharpMaskData;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("CaptureEditorMetadata[");
        buffer.append("\n>>>>Orientation: " + this.getOrientation() + " degrees, ");
        buffer.append("\n>>>>crop: " + this.getCropLeft() + ", " + this.getCropTop() + ", " + this.getCropWidth() + ", " + this.getCropHeight());
        if (this.isAdvancedRawEnabled()) {
            buffer.append("\n>>>>EV compensation: " + (double)this.getEVCompensation() / 100.0 + ", ");
            buffer.append("Sharpening: " + NikonCaptureEditorMetadata.getConstant(sharpeningMap, this.getSharpening()) + ", ");
            buffer.append("Tone comp: " + NikonCaptureEditorMetadata.getConstant(toneCompMap, this.getToneCompensation()) + ", ");
            buffer.append("Color mode: " + NikonCaptureEditorMetadata.getConstant(colorModeMap, this.getColorMode()) + ", ");
            if (this.isHueCorrectionEnabled()) {
                buffer.append("Hue correction: " + NikonCaptureEditorMetadata.getConstant(hueMap, this.getHueCorrection()) + ", ");
            }
            if (this.isSaturationCompensationEnabled()) {
                buffer.append("Saturation compensation: " + this.getSaturationCompensation() + ", ");
            }
        }
        if (this.isWhiteBalanceEnabled()) {
            buffer.append("\n>>>>Red: " + this.getWhiteBalanceRedCoeff() + ", ");
            buffer.append("Blue: " + this.getWhiteBalanceBlueCoeff() + ", ");
            buffer.append("White point: " + this.getWhitePointAsString(this.getWhiteBalanceWhitePoint()) + ", ");
            buffer.append("White point fine: " + this.getWhiteBalanceWhitePointFine() + ", ");
            buffer.append("Temperature: " + this.getWhiteBalanceTemperature());
        }
        if (this.isColorBoosterEnabled()) {
            buffer.append("\n>>>>ColorBooster type: " + NikonCaptureEditorMetadata.getConstant(colorBoosterMap, this.getColorBoosterType()) + ", ");
            buffer.append("ColorBooster value: " + this.getColorBoosterLevel());
        }
        if (this.isNoiseReductionEnabled()) {
            buffer.append("\n>>>>Noise reduction: " + this.getNoiseReduction() + ", ");
            buffer.append("Edge reduction: " + this.isEdgeNoiseReductionEnabled() + ", ");
            buffer.append("Moire reduction: " + NikonCaptureEditorMetadata.getConstant(moireReductionMap, this.getMoireReduction()));
        }
        if (this.isPhotoEffectEnabled()) {
            buffer.append("\n>>>>Effect: " + NikonCaptureEditorMetadata.getConstant(photoEffectMap, this.getPhotoEffect()) + ", ");
            buffer.append("Cyan/Red balance: " + this.getCyanRedBalance() + ", ");
            buffer.append("Magenta/Green balance: " + this.getMagentaGreenBalance() + ", ");
            buffer.append("Yellow/Bluebalance: " + this.getYellowBlueBalance());
        }
        if (this.isUnsharpMaskEnabled()) {
            UnsharpMaskData[] unsharpMaskData = this.getUnsharpMaskData();
            for (int i = 0; i < unsharpMaskData.length; ++i) {
                buffer.append("\n>>>>Unsharp mask[" + i + "]: ");
                buffer.append("type: " + NikonCaptureEditorMetadata.getConstant(unsharpMaskMap, unsharpMaskData[i].getType()) + ", ");
                buffer.append("intensity: " + unsharpMaskData[i].getIntensity() + "%, ");
                buffer.append("halo width: " + unsharpMaskData[i].getHaloWidth() + "%, ");
                buffer.append("threshold: " + unsharpMaskData[i].getThreshold());
            }
        }
        buffer.append("\n]");
        return buffer.toString();
    }

    public String getWhitePointAsString(int whitePoint) {
        return NikonCaptureEditorMetadata.getConstant(white1Map, whitePoint);
    }

    public String getWhitePointFineAsString(int whitePoint) {
        return NikonCaptureEditorMetadata.getConstant(white2Map, whitePoint);
    }

    private static void registerConstant(Map map, int key, String text) {
        map.put(new Integer(key), text);
    }

    private static String getConstant(Map map, int key) {
        String string = (String)map.get(new Integer(key));
        return string != null ? string : "#" + key + " - 0x" + Integer.toHexString(key);
    }

    public static String getColorModeAsString(int colorMode) {
        return NikonCaptureEditorMetadata.getConstant(colorModeMap, colorMode);
    }

    public static String getSharpeningAsString(int sharpening) {
        return NikonCaptureEditorMetadata.getConstant(sharpeningMap, sharpening);
    }

    public static String getToneCompensationAsString(int toneComp) {
        return NikonCaptureEditorMetadata.getConstant(toneCompMap, toneComp);
    }

    public static String getUnsharpMaskTypeAsString(int type) {
        return NikonCaptureEditorMetadata.getConstant(unsharpMaskMap, type);
    }

    private String getDebugString(int offset, int id, int size, ByteBuffer subBuffer, int i) {
        StringBuffer bbb = new StringBuffer();
        bbb.append("subBuffer #");
        bbb.append(i);
        bbb.append(" ");
        bbb.append(Integer.toHexString(id));
        bbb.append(" at ");
        bbb.append(Integer.toHexString(offset));
        bbb.append(", size: ");
        bbb.append(size);
        bbb.append(", data: ");
        for (int j = 0; j < size; ++j) {
            int b = subBuffer.get(j) & 0xFF;
            if (b < 16) {
                bbb.append("0");
            }
            bbb.append(Integer.toHexString(b));
            if (j > 64) {
                bbb.append("...");
                break;
            }
            bbb.append(" ");
        }
        String s = bbb.toString();
        return s;
    }

    static {
        NikonCaptureEditorMetadata.registerConstant(colorModeMap, 0, "unchanged");
        NikonCaptureEditorMetadata.registerConstant(colorModeMap, 1, "mode I (sRGB)");
        NikonCaptureEditorMetadata.registerConstant(colorModeMap, 2, "mode II (Adobe RGB)");
        NikonCaptureEditorMetadata.registerConstant(colorModeMap, 4, "mode III (sRGB)");
        NikonCaptureEditorMetadata.registerConstant(hueMap, 0, "-9");
        NikonCaptureEditorMetadata.registerConstant(hueMap, 1, "-6");
        NikonCaptureEditorMetadata.registerConstant(hueMap, 2, "-3");
        NikonCaptureEditorMetadata.registerConstant(hueMap, 3, "none");
        NikonCaptureEditorMetadata.registerConstant(hueMap, 4, "+3");
        NikonCaptureEditorMetadata.registerConstant(hueMap, 5, "+6");
        NikonCaptureEditorMetadata.registerConstant(hueMap, 6, "+9");
        NikonCaptureEditorMetadata.registerConstant(toneCompMap, 0, "unchanged");
        NikonCaptureEditorMetadata.registerConstant(toneCompMap, 2, "low");
        NikonCaptureEditorMetadata.registerConstant(toneCompMap, 1, "normal");
        NikonCaptureEditorMetadata.registerConstant(toneCompMap, 3, "high");
        NikonCaptureEditorMetadata.registerConstant(toneCompMap, 4, "user defined curve");
        NikonCaptureEditorMetadata.registerConstant(toneCompMap, 5, "medium low");
        NikonCaptureEditorMetadata.registerConstant(toneCompMap, 6, "medium high");
        NikonCaptureEditorMetadata.registerConstant(sharpeningMap, 0, "unchanged");
        NikonCaptureEditorMetadata.registerConstant(sharpeningMap, 1, "none");
        NikonCaptureEditorMetadata.registerConstant(sharpeningMap, 2, "low");
        NikonCaptureEditorMetadata.registerConstant(sharpeningMap, 3, "normal");
        NikonCaptureEditorMetadata.registerConstant(sharpeningMap, 4, "high");
        NikonCaptureEditorMetadata.registerConstant(white1Map, 1, "use gray point");
        NikonCaptureEditorMetadata.registerConstant(white1Map, 2, "recorded value");
        NikonCaptureEditorMetadata.registerConstant(white1Map, 3, "set");
        NikonCaptureEditorMetadata.registerConstant(white1Map, 4, "auto");
        NikonCaptureEditorMetadata.registerConstant(white2Map, 256, "incandescent");
        NikonCaptureEditorMetadata.registerConstant(white2Map, 512, "daylight/direct sunlight");
        NikonCaptureEditorMetadata.registerConstant(white2Map, 514, "daylight/cloudy");
        NikonCaptureEditorMetadata.registerConstant(white2Map, 513, "daylight/shade");
        NikonCaptureEditorMetadata.registerConstant(white2Map, 768, "standard fluorescent/warm white");
        NikonCaptureEditorMetadata.registerConstant(white2Map, 769, "standard fluorescent/3700K");
        NikonCaptureEditorMetadata.registerConstant(white2Map, 770, "standard fluorescent/cool white");
        NikonCaptureEditorMetadata.registerConstant(white2Map, 771, "standard fluorescent/5000K");
        NikonCaptureEditorMetadata.registerConstant(white2Map, 772, "standard fluorescent/daylight");
        NikonCaptureEditorMetadata.registerConstant(white2Map, 1024, "hicolor fluorescent/warm white");
        NikonCaptureEditorMetadata.registerConstant(white2Map, 1025, "hicolor fluorescent/3700K");
        NikonCaptureEditorMetadata.registerConstant(white2Map, 1026, "hicolor fluorescent/cool white");
        NikonCaptureEditorMetadata.registerConstant(white2Map, 1027, "hicolor fluorescent/5000K");
        NikonCaptureEditorMetadata.registerConstant(white2Map, 1028, "hicolor fluorescent/daylight");
        NikonCaptureEditorMetadata.registerConstant(white2Map, 1280, "flash");
        NikonCaptureEditorMetadata.registerConstant(colorBoosterMap, 0, "nature");
        NikonCaptureEditorMetadata.registerConstant(colorBoosterMap, 1, "people");
        NikonCaptureEditorMetadata.registerConstant(moireReductionMap, 0, "off");
        NikonCaptureEditorMetadata.registerConstant(moireReductionMap, 1, "low");
        NikonCaptureEditorMetadata.registerConstant(moireReductionMap, 2, "medium");
        NikonCaptureEditorMetadata.registerConstant(moireReductionMap, 3, "high");
        NikonCaptureEditorMetadata.registerConstant(photoEffectMap, 0, "none");
        NikonCaptureEditorMetadata.registerConstant(photoEffectMap, 1, "black & white");
        NikonCaptureEditorMetadata.registerConstant(photoEffectMap, 2, "sepia");
        NikonCaptureEditorMetadata.registerConstant(photoEffectMap, 3, "tinted");
        NikonCaptureEditorMetadata.registerConstant(unsharpMaskMap, 0, "RGB");
        NikonCaptureEditorMetadata.registerConstant(unsharpMaskMap, 1, "RED");
        NikonCaptureEditorMetadata.registerConstant(unsharpMaskMap, 2, "GREEN");
        NikonCaptureEditorMetadata.registerConstant(unsharpMaskMap, 3, "BLUE");
        NikonCaptureEditorMetadata.registerConstant(unsharpMaskMap, 4, "YELLOW");
        NikonCaptureEditorMetadata.registerConstant(unsharpMaskMap, 5, "MAGENTA");
        NikonCaptureEditorMetadata.registerConstant(unsharpMaskMap, 6, "CYAN");
        NikonCaptureEditorMetadata.registerConstant(markerMap, 1966984128, "NoiseReduction");
        NikonCaptureEditorMetadata.registerConstant(markerMap, -1838214176, "NoiseReductionData");
        NikonCaptureEditorMetadata.registerConstant(markerMap, 1990472196, "WhiteBalance");
        NikonCaptureEditorMetadata.registerConstant(markerMap, -1086559200, "WhiteBalanceData");
        NikonCaptureEditorMetadata.registerConstant(markerMap, 1990472195, "AdvancedRaw");
        NikonCaptureEditorMetadata.registerConstant(markerMap, 1453671008, "AdvancedRawData");
        NikonCaptureEditorMetadata.registerConstant(markerMap, 1594785059, "ColorBooster");
        NikonCaptureEditorMetadata.registerConstant(markerMap, -1181113489, "ColorBoosterData");
        NikonCaptureEditorMetadata.registerConstant(markerMap, 1990472192, "UnsharpMask");
        NikonCaptureEditorMetadata.registerConstant(markerMap, -466923167, "UnsharpMaskData");
        NikonCaptureEditorMetadata.registerConstant(markerMap, 927085536, "Crop");
        NikonCaptureEditorMetadata.registerConstant(markerMap, 1990472199, "Orientation");
        NikonCaptureEditorMetadata.registerConstant(markerMap, 1990472197, "Vignette");
        NikonCaptureEditorMetadata.registerConstant(markerMap, 1990472194, "ColorBalance");
        NikonCaptureEditorMetadata.registerConstant(markerMap, 1990472193, "Curves");
        NikonCaptureEditorMetadata.registerConstant(markerMap, -128813699, "DustReference");
        NikonCaptureEditorMetadata.registerConstant(markerMap, -1419851170, "PhotoEffects");
        NikonCaptureEditorMetadata.registerConstant(markerMap, -1338487266, "PhotoEffectsData");
    }

    public static class UnsharpMaskData {
        public static final int RGB = 0;
        public static final int RED = 1;
        public static final int GREEN = 2;
        public static final int BLUE = 3;
        public static final int YELLOW = 4;
        public static final int MAGENTA = 5;
        public static final int CYAN = 6;
        private int type;
        private int intensity;
        private int haloWidth;
        private int threshold;

        public UnsharpMaskData(int type, int intensity, int haloWidth, int threshold) {
            this.type = type;
            this.intensity = intensity;
            this.haloWidth = haloWidth;
            this.threshold = threshold;
        }

        public int getHaloWidth() {
            return this.haloWidth;
        }

        public int getIntensity() {
            return this.intensity;
        }

        public int getThreshold() {
            return this.threshold;
        }

        public int getType() {
            return this.type;
        }
    }
}

