/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.nef;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.nef.NEFWhiteBalanceInfo;
import it.tidalwave.imageio.nef.Nikon3MakerNoteSupport;
import it.tidalwave.imageio.nef.NikonLensInfo;
import it.tidalwave.imageio.tiff.TIFFImageReaderSupport;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.NoSuchElementException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public final class NikonMakerNote3
extends Nikon3MakerNoteSupport {
    private static final long serialVersionUID = -802326201633669892L;
    private transient NikonLensInfo lensInfo;
    private boolean bigEndian;

    public void loadAll(@Nonnull RAWImageInputStream iis, long offset) throws IOException {
        iis.seek(offset);
        long baseOffsetSave = iis.getBaseOffset();
        ByteOrder byteOrderSave = iis.getByteOrder();
        iis.setBaseOffset(0L);
        offset = iis.getStreamPosition();
        byte[] buffer = new byte[10];
        iis.readFully(buffer);
        String s = new String(buffer);
        if (s.startsWith("Nikon")) {
            iis.setBaseOffset(iis.getStreamPosition());
            offset = TIFFImageReaderSupport.processHeader(iis, null);
        }
        this.bigEndian = iis.getByteOrder() == ByteOrder.BIG_ENDIAN;
        super.loadAll(iis, offset);
        iis.setBaseOffset(baseOffsetSave);
        iis.setByteOrder(byteOrderSave);
    }

    @Nonnull
    public NikonLensInfo getLensInfo2() {
        if (this.lensInfo == null && this.isLensInfoAvailable()) {
            this.lensInfo = new NikonLensInfo(this.getLensInfo());
        }
        return this.lensInfo;
    }

    public boolean isLensNameAvailable() {
        NikonLensInfo lensInfo = this.getLensInfo2();
        return lensInfo != null && lensInfo.getLensName() != null;
    }

    public String getLensName() {
        if (!this.isLensNameAvailable()) {
            throw new NoSuchElementException();
        }
        return this.getLensInfo2().getLensName();
    }

    @Nonnull
    public int[] getVPredictor() {
        ShortBuffer shortBuffer = this.getCompressionDataAsShortBuffer();
        shortBuffer.position(1);
        int[] vPredictor = new int[4];
        for (int i = 0; i < vPredictor.length; ++i) {
            vPredictor[i] = shortBuffer.get();
        }
        return vPredictor;
    }

    @Nonnull
    public int[] getLinearizationTable() {
        ShortBuffer shortBuffer = this.getCompressionDataAsShortBuffer();
        shortBuffer.position(5);
        int lutSize = shortBuffer.get();
        int[] lut = new int[lutSize];
        for (int i = 0; i < lutSize; ++i) {
            lut[i] = shortBuffer.get() & 0xFFFF;
        }
        return lut;
    }

    @CheckForNull
    private ShortBuffer getCompressionDataAsShortBuffer() {
        byte[] bytes = this.getCompressionData();
        if (bytes != null) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
            ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
            if ((shortBuffer.get(5) & 0xFFFF) > 4096) {
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                shortBuffer = byteBuffer.asShortBuffer();
            }
            return shortBuffer;
        }
        return null;
    }

    @CheckForNull
    public NEFWhiteBalanceInfo getWhiteBalanceInfo() {
        return this.isBlock151Available() ? new NEFWhiteBalanceInfo(this, this.bigEndian) : null;
    }

    @Nonnull
    public String toString() {
        StringBuffer buffer = new StringBuffer(super.toString());
        if (this.isLensInfoAvailable()) {
            buffer.append("\n>>>>LensInfo:" + this.getLensInfo2());
        }
        return buffer.toString();
    }
}

