/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.orf;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.orf.ORFRasterReader;
import it.tidalwave.imageio.raw.RAWImageReaderSupport;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class CSeriesRasterReader
extends ORFRasterReader {
    private static final int BITS_PER_PIXEL = 8;
    private static final int BITS_COUNT = 11;
    private static final int MASK = 4095;
    private int rowByteCount;

    protected void loadUncompressedRaster(@Nonnull RAWImageInputStream iis, @Nonnull WritableRaster raster, @Nonnull RAWImageReaderSupport ir) throws IOException {
        this.rowByteCount = raster.getWidth() * this.bitsPerSample / 8;
        super.loadUncompressedRaster(iis, raster, ir);
    }

    protected int getRow(@Nonnegative int y, @Nonnegative int height) {
        return y <= height / 2 ? y * 2 : (y - height / 2) * 2 - 1;
    }

    @Nonnegative
    protected int getSkipCountAtEndOfRow(@Nonnegative int y, @Nonnegative int height) {
        if (y != height / 2) {
            return 0;
        }
        int delta = 4096 - ((y + 1) * this.rowByteCount & 0xFFF);
        return delta * 8;
    }
}

