/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.orf;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.orf.ORFRasterReader;
import it.tidalwave.imageio.raw.RAWImageReaderSupport;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.annotation.Nonnull;

public class E410RasterReader
extends ORFRasterReader {
    protected void loadUncompressedRaster(@Nonnull RAWImageInputStream iis, @Nonnull WritableRaster raster, @Nonnull RAWImageReaderSupport ir) throws IOException {
        DataBufferUShort dataBuffer = (DataBufferUShort)raster.getDataBuffer();
        short[] data = dataBuffer.getData();
        int width = raster.getWidth();
        int height = raster.getHeight();
        int pixelStride = 3;
        int scanStride = width * 3;
        this.selectBitReader(iis, raster, -1);
        int[][] acarry = new int[2][3];
        iis.skipBytes(7);
        for (int y = 0; y < height; ++y) {
            int k = y % 2 * 2;
            int ii = y * scanStride;
            for (int acar = 0; acar < acarry.length; ++acar) {
                for (int acac = 0; acac < acarry[acar].length; ++acac) {
                    acarry[acar][acac] = 0;
                }
            }
            for (int x = 0; x < width; ++x) {
                short pred;
                int high;
                int j = x % 2;
                int[] carry = acarry[x & 1];
                int i = 2 * (carry[2] < 3 ? 1 : 0);
                int nbits = 2 + i;
                while ((carry[0] & 0xFFFF) >> nbits + i != 0) {
                    ++nbits;
                }
                int sign = iis.readBit() * -1;
                int low = (int)iis.readBits(2);
                for (high = 0; high < 12 && iis.readBit() == 0; ++high) {
                }
                if (high == 12) {
                    high = (int)iis.readBits(16 - nbits) >> 1;
                }
                carry[0] = (int)((long)(high << nbits) | iis.readBits(nbits));
                int diff = (carry[0] ^ sign) + carry[1];
                carry[1] = diff * 3 + carry[1] >> 5;
                int n = carry[2] = carry[0] > 16 ? 0 : carry[2] + 1;
                if (y < 2 && x < 2) {
                    pred = 0;
                } else if (y < 2) {
                    pred = data[ii + this.cfaOffsets[j + k] - 6];
                } else if (x < 2) {
                    pred = data[ii + this.cfaOffsets[j + k] - 2 * scanStride];
                } else {
                    short w = data[ii + this.cfaOffsets[j + k] - 6];
                    short n2 = data[ii + this.cfaOffsets[j + k] - 2 * scanStride];
                    short nw = data[ii + this.cfaOffsets[j + k] - 2 * scanStride - 6];
                    pred = w < nw && nw < n2 || n2 < nw && nw < w ? (Math.abs(w - nw) > 32 || Math.abs(n2 - nw) > 32 ? w + n2 - nw : w + n2 >> 1) : (Math.abs(w - nw) > Math.abs(n2 - nw) ? w : n2);
                }
                int xxx = pred + (diff << 2 | low);
                data[ii + this.cfaOffsets[j + k]] = (short)xxx;
                if (xxx >> 12 != 0) {
                    throw new IOException("Error in decompression");
                }
                ii += 3;
            }
            ir.processImageProgress(100.0f * (float)y / (float)height);
        }
    }
}

