/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.orf;

import it.tidalwave.imageio.orf.ORFMetadata;
import it.tidalwave.imageio.orf.ORFRasterReader;
import it.tidalwave.imageio.orf.OlympusMakerNote;
import it.tidalwave.imageio.raw.RasterReader;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.TIFFImageReaderSupport;
import it.tidalwave.imageio.util.Logger;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.imageio.spi.ImageReaderSpi;

public class ORFImageReader
extends TIFFImageReaderSupport {
    private static final String CLASS = ORFImageReader.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    protected ORFImageReader(@Nonnull ImageReaderSpi originatingProvider, @CheckForNull Object extension) {
        super(originatingProvider, OlympusMakerNote.class, ORFMetadata.class);
    }

    protected WritableRaster loadRAWRaster() throws IOException {
        logger.fine("loadRAWRaster() - iis %s", this.iis);
        long time = System.currentTimeMillis();
        String model = ((IFD)this.primaryDirectory).getModel();
        ORFRasterReader rasterReader = ORFRasterReader.getInstance(model);
        this.initializeRasterReader(rasterReader);
        logger.finest(">>>> using rasterReader: %s", rasterReader);
        IFD primaryIFD = (IFD)this.primaryDirectory;
        this.iis.seek(primaryIFD.getStripOffsets());
        WritableRaster raster = rasterReader.loadRaster(this.iis, this);
        logger.finer(">>>> loadRAWRaster() completed ok in %d msec", System.currentTimeMillis() - time);
        return raster;
    }

    protected void initializeRasterReader(@Nonnull RasterReader rasterReader) {
        IFD primaryIFD = (IFD)this.primaryDirectory;
        IFD exifIFD = (IFD)primaryIFD.getNamedDirectory("EXIF");
        int bitsPerSample = primaryIFD.getBitsPerSample()[0];
        int width = primaryIFD.getImageWidth();
        int height = primaryIFD.getImageLength();
        rasterReader.setWidth(width);
        rasterReader.setHeight(height);
        rasterReader.setBitsPerSample(bitsPerSample);
        rasterReader.setCFAPattern(exifIFD.getEXIFCFAPattern());
        rasterReader.setCompression(primaryIFD.getCompression().intValue());
        if (primaryIFD.isStripByteCountsAvailable()) {
            rasterReader.setStripByteCount(primaryIFD.getStripByteCounts());
        }
        if (primaryIFD.isTileWidthAvailable()) {
            int tileWidth = primaryIFD.getTileWidth();
            int tileLength = primaryIFD.getTileLength();
            rasterReader.setTileWidth(tileWidth);
            rasterReader.setTileHeight(tileLength);
            rasterReader.setTilesAcross((width + tileWidth - 1) / tileWidth);
            rasterReader.setTilesDown((height + tileLength - 1) / tileLength);
            rasterReader.setTileOffsets(primaryIFD.getTileOffsets());
        }
        if (primaryIFD.isLinearizationTableAvailable()) {
            rasterReader.setLinearizationTable(primaryIFD.getLinearizationTable());
        }
    }
}

