/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.orf;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.orf.OlympusMakerNote;
import it.tidalwave.imageio.raw.Directory;
import it.tidalwave.imageio.raw.HeaderProcessor;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.TIFFMetadataSupport;
import it.tidalwave.imageio.util.Logger;
import java.io.IOException;
import java.util.NoSuchElementException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class ORFMetadata
extends TIFFMetadataSupport {
    private static final String CLASS = ORFMetadata.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private static final long serialVersionUID = 1795868418676854749L;

    public ORFMetadata(@Nonnull Directory primaryIFD, @Nonnull RAWImageInputStream iis, @Nonnull HeaderProcessor headerProcessor) {
        super(primaryIFD, iis, headerProcessor);
        OlympusMakerNote olympusMakerNote = this.getOlympusMakerNote();
        if (olympusMakerNote != null) {
            try {
                this.thumbnailHelperList.add(olympusMakerNote.loadThumbnailHelper(iis));
            }
            catch (IOException e) {
                logger.warning("Cannot load thumbnail: " + e, new Object[0]);
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
        }
    }

    @CheckForNull
    public OlympusMakerNote getOlympusMakerNote() {
        return (OlympusMakerNote)this.getMakerNote();
    }

    protected boolean isRasterIFD(@Nonnull IFD ifd) {
        return ifd.isPhotometricInterpretationAvailable();
    }

    protected boolean isThumbnailIFD(@Nonnull IFD ifd) {
        return ifd.isJPEGInterchangeFormatAvailable();
    }
}

