/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.orf;

import it.tidalwave.imageio.orf.CSeriesRasterReader;
import it.tidalwave.imageio.orf.E300RasterReader;
import it.tidalwave.imageio.orf.E410RasterReader;
import it.tidalwave.imageio.raw.RasterReader;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class ORFRasterReader
extends RasterReader {
    private static final CSeriesRasterReader C_SERIES_RASTER_READER = new CSeriesRasterReader();
    private static final E300RasterReader E300_RASTER_READER = new E300RasterReader();
    private static final E410RasterReader E410_RASTER_READER = new E410RasterReader();
    private static final Map<String, ORFRasterReader> rasterReaderMapByModel = new HashMap<String, ORFRasterReader>();

    @Nonnull
    public static ORFRasterReader getInstance(@Nonnull String model) {
        ORFRasterReader rasterReader = rasterReaderMapByModel.get(model = model.toUpperCase().trim());
        if (rasterReader != null) {
            return rasterReader;
        }
        if (model.startsWith("C")) {
            return C_SERIES_RASTER_READER;
        }
        return new ORFRasterReader();
    }

    @Nonnull
    public String toString() {
        return "ORFRasterReader";
    }

    static {
        rasterReaderMapByModel.put("E-300", E300_RASTER_READER);
        rasterReaderMapByModel.put("E-410", E410_RASTER_READER);
        rasterReaderMapByModel.put("E-500", E300_RASTER_READER);
        rasterReaderMapByModel.put("E-510", E410_RASTER_READER);
    }
}

