/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.pef;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.pef.PentaxMakerNote;
import it.tidalwave.imageio.raw.Directory;
import it.tidalwave.imageio.raw.HeaderProcessor;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.TIFFMetadataSupport;
import it.tidalwave.imageio.tiff.ThumbnailHelper;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class PEFMetadata
extends TIFFMetadataSupport {
    private static final long serialVersionUID = 1795868418676854749L;

    public PEFMetadata(@Nonnull Directory primaryIFD, @Nonnull RAWImageInputStream iis, @Nonnull HeaderProcessor headerProcessor) {
        super(primaryIFD, iis, headerProcessor);
    }

    protected void postInit(@Nonnull RAWImageInputStream iis) {
        PentaxMakerNote makerNote = this.getPentaxMakerNote();
        if (makerNote.isPreviewThumbnailDimensionsAvailable()) {
            int thumbnailOffset = makerNote.getPreviewThumbnailOffset();
            int thumbnailSize = makerNote.getPreviewThumbnailSize();
            int thumbnailWidth = makerNote.getPreviewThumbnailDimensions()[0];
            int thumbnailHeight = makerNote.getPreviewThumbnailDimensions()[1];
            this.thumbnailHelperList.add(new ThumbnailHelper(iis, thumbnailOffset, thumbnailSize, thumbnailWidth, thumbnailHeight));
        }
    }

    @CheckForNull
    public PentaxMakerNote getPentaxMakerNote() {
        return (PentaxMakerNote)this.getMakerNote();
    }

    protected boolean isRasterIFD(@Nonnull IFD ifd) {
        return ifd.isPhotometricInterpretationAvailable();
    }

    protected boolean isThumbnailIFD(@Nonnull IFD ifd) {
        return ifd.isJPEGInterchangeFormatAvailable();
    }
}

