/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.raw;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.raw.AbstractTag;
import it.tidalwave.imageio.raw.TagRational;
import it.tidalwave.imageio.raw.TagRegistry;
import it.tidalwave.imageio.util.Logger;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Directory
implements Serializable {
    private static final String CLASS = Directory.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private static final long serialVersionUID = 7068468438676854749L;
    protected long start;
    protected long end;
    private final Map<Object, AbstractTag> tagMapByKey = new HashMap<Object, AbstractTag>();
    private final List<Object> keyList = new ArrayList<Object>();
    protected Directory nextDirectory;
    private final Collection<Directory> directoryList = new ArrayList<Directory>();
    private Map<String, Directory> directoryMapByName = new HashMap<String, Directory>();
    private String registryName;
    protected transient TagRegistry tagRegistry;

    public Directory() {
    }

    protected Directory(@Nonnull TagRegistry tagRegistry) {
        this.tagRegistry = tagRegistry;
        this.registryName = tagRegistry.getName();
    }

    @Nonnull
    public TagRegistry getRegistry() {
        return this.tagRegistry;
    }

    @Nonnegative
    public long getStart() {
        return this.start;
    }

    @Nonnegative
    public long getEnd() {
        return this.end;
    }

    public abstract long load(@Nonnull RAWImageInputStream var1, long var2) throws IOException;

    public void loadAll(@Nonnull RAWImageInputStream iis, @Nonnull long offset) throws IOException {
        this.load(iis, offset);
    }

    public void addTag(@Nonnull AbstractTag tag) {
        if (tag != null) {
            Integer key = new Integer(tag.getCode());
            this.tagMapByKey.put(this.tagRegistry.getKey(key), tag);
            this.keyList.add(this.tagRegistry.getKey(key));
        }
    }

    @CheckForNull
    public AbstractTag getTag(@Nonnull Object key) {
        return this.tagMapByKey.get(this.tagRegistry.getKey(key));
    }

    public boolean containsTag(@Nonnull Object key) {
        return this.tagRegistry != null && this.tagMapByKey.containsKey(this.tagRegistry.getKey(key));
    }

    @CheckForNull
    public AbstractTag removeTag(@Nonnull Object key) {
        this.keyList.remove(this.tagRegistry.getKey(key));
        return this.tagMapByKey.remove(this.tagRegistry.getKey(key));
    }

    @Nonnull
    public String getTagName(@Nonnull Object key) {
        return this.tagRegistry.getTagName(((Number)key).intValue());
    }

    @CheckForNull
    public Object getObject(@Nonnull Object key) {
        AbstractTag tag = this.getTag(key);
        return tag != null ? tag.getValue() : null;
    }

    @CheckForNull
    public byte[] getBytes(@Nonnull Object key) {
        AbstractTag tag = this.getTag(key);
        return tag != null ? tag.getByteValues() : null;
    }

    public int getByte(@Nonnull Object key) {
        if (!this.containsTag(key)) {
            throw new NoSuchElementException("No tags with key = " + key);
        }
        return this.getBytes(key)[0];
    }

    @CheckForNull
    public TagRational[] getRationals(@Nonnull Object key) {
        AbstractTag tag = this.getTag(key);
        return tag != null ? tag.getRationalValues() : null;
    }

    @Nonnull
    public TagRational getRational(@Nonnull Object key) {
        if (!this.containsTag(key)) {
            throw new NoSuchElementException("No tags with key = " + key);
        }
        return this.getRationals(key)[0];
    }

    @CheckForNull
    public double[] getDoubles(@Nonnull Object key) {
        AbstractTag tag = this.getTag(key);
        return tag != null ? Directory.asDoubles(tag.getRationalValues()) : null;
    }

    public double getDouble(@Nonnull Object key) {
        if (!this.containsTag(key)) {
            throw new NoSuchElementException("No tags with key = " + key);
        }
        return this.getRationals(key)[0].doubleValue();
    }

    @CheckForNull
    public float[] getFloats(@Nonnull Object key) {
        AbstractTag tag = this.getTag(key);
        return tag != null ? tag.getFloatValues() : null;
    }

    public float getFloat(@Nonnull Object key) {
        if (!this.containsTag(key)) {
            throw new NoSuchElementException("No tags with key = " + key);
        }
        return this.getRationals(key)[0].floatValue();
    }

    @CheckForNull
    public int[] getIntegers(@Nonnull Object key) {
        AbstractTag tag = this.getTag(key);
        if (tag == null) {
            return null;
        }
        int[] intValues = tag.getIntValues();
        if (intValues != null) {
            return intValues;
        }
        byte[] byteValues = tag.getByteValues();
        if (byteValues != null) {
            intValues = new int[byteValues.length];
            for (int i = 0; i < byteValues.length; ++i) {
                intValues[i] = byteValues[i] & 0xFF;
            }
            return intValues;
        }
        return null;
    }

    public int getInteger(@Nonnull Object key) throws NoSuchElementException {
        if (!this.containsTag(key)) {
            throw new NoSuchElementException("No tags with key = " + key);
        }
        int[] i = this.getIntegers(key);
        if (i.length == 0) {
            return 0;
        }
        return i[0];
    }

    @CheckForNull
    public String getString(@Nonnull Object key) {
        AbstractTag tag = this.getTag(key);
        return tag != null ? tag.getASCIIValue() : null;
    }

    @CheckForNull
    public Directory getNextDirectory() {
        return this.nextDirectory;
    }

    public void addDirectory(@Nonnull Directory subDirectory) {
        this.directoryList.add(subDirectory);
    }

    @Nonnull
    public Collection<Directory> getSubDirectories() {
        return Collections.unmodifiableCollection(this.directoryList);
    }

    public void addNamedDirectory(@Nonnull String name, @Nonnull Directory subDirectory) {
        this.directoryMapByName.put(name, subDirectory);
    }

    @CheckForNull
    public Directory getNamedDirectory(@Nonnull String name) {
        return this.directoryMapByName.get(name);
    }

    @CheckForNull
    public String[] getSubDirectoryNames() {
        return this.directoryMapByName.keySet().toArray(new String[0]);
    }

    @Nonnull
    public Collection<AbstractTag> getTags() {
        ArrayList<AbstractTag> result = new ArrayList<AbstractTag>();
        for (Object key : this.keyList) {
            result.add(this.tagMapByKey.get(key));
        }
        return result;
    }

    @CheckForNull
    public static float[] asFloats(@CheckForNull TagRational[] rationals) {
        if (rationals == null) {
            return null;
        }
        float[] floats = new float[rationals.length];
        for (int i = 0; i < rationals.length; ++i) {
            floats[i] = rationals[i].floatValue();
        }
        return floats;
    }

    @CheckForNull
    public static double[] asDoubles(@CheckForNull TagRational[] rationals) {
        if (rationals == null) {
            return null;
        }
        double[] doubles = new double[rationals.length];
        for (int i = 0; i < rationals.length; ++i) {
            doubles[i] = rationals[i].doubleValue();
        }
        return doubles;
    }

    @Nonnull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(String.format("%d - %d (0x%x - 0x%x)", this.start, this.end, this.start, this.end));
        for (Object key : this.keyList) {
            buffer.append("\n>>>>>>>> ");
            AbstractTag value = this.tagMapByKey.get(key);
            buffer.append(value);
        }
        buffer.append("\n");
        return buffer.toString();
    }

    @Nonnull
    protected String toString(@Nonnull byte[] array) {
        if (array.length > 64) {
            return "" + array.length + " bytes";
        }
        StringBuilder buffer = new StringBuilder("");
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(Integer.toHexString(array[i] & 0xFF));
        }
        return buffer.toString();
    }

    @Nonnull
    protected String toString(@Nonnull int[] array) {
        if (array.length > 64) {
            return "" + array.length + " integers";
        }
        StringBuilder buffer = new StringBuilder("");
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(Integer.toString(array[i]));
        }
        return buffer.toString();
    }

    @Nonnull
    protected String toString(@Nonnull double[] array) {
        if (array.length > 64) {
            return "" + array.length + " doubles";
        }
        StringBuilder buffer = new StringBuilder("");
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(Double.toString(array[i]));
        }
        return buffer.toString();
    }

    @Nonnull
    protected String toString(@Nonnull TagRational[] array) {
        StringBuilder buffer = new StringBuilder("");
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(array[i].toString());
        }
        return buffer.toString();
    }

    private void readObject(@Nonnull ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
        this.tagRegistry = TagRegistry.getRegistry(this.registryName);
    }

    public static class Enumeration
    implements Serializable {
        private static final long serialVersionUID = 4029468438676854749L;
        private int intValue;
        private String stringValue;
        private String description;

        protected Enumeration(int value, String description) {
            this.intValue = value;
            this.description = description;
        }

        protected Enumeration(int[] value, String description) {
            this(value[0], description);
        }

        protected Enumeration(String value, String description) {
            this.stringValue = value;
            this.description = description;
        }

        protected Enumeration(String[] value, String description) {
            this(value[0], description);
        }

        public int intValue() {
            return this.intValue;
        }

        public String toString() {
            if (this.stringValue != null) {
                return this.description.equals("reserved") ? this.description + "#" + this.stringValue : this.description;
            }
            return this.description.equals("reserved") ? this.description + "#" + this.intValue : this.description;
        }

        public int hashCode() {
            if (this.stringValue != null) {
                return this.stringValue.hashCode();
            }
            return this.intValue;
        }

        public boolean equals(Object object) {
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Enumeration e = (Enumeration)object;
            if (this.stringValue != null) {
                return this.stringValue.equals(e.stringValue);
            }
            return this.intValue == e.intValue;
        }

        protected static boolean equals(int i1, int i2) {
            return i1 == i2;
        }

        protected static boolean equals(int[] i1, int i2) {
            return i1[0] == i2;
        }

        protected static boolean equals(String s1, String s2) {
            if (s1 == s2) {
                return true;
            }
            if (s1 == null) {
                return false;
            }
            return Enumeration.trim(s1).equals(Enumeration.trim(s2));
        }

        private static String trim(String s) {
            return s == null ? null : s.trim();
        }
    }
}

