/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.raw;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.raw.PostProcessor;
import it.tidalwave.imageio.raw.RAWMetadataSupport;
import it.tidalwave.imageio.raw.Version;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public abstract class RAWImageReaderSpiSupport
extends ImageReaderSpi {
    private static Map postProcessorMapBySpiClass = new HashMap();

    protected RAWImageReaderSpiSupport(String[] names, String[] suffixes, String[] MIMETypes, Class readerClass, Class[] inputTypes, String[] writerSpiNames, boolean supportsStandardStreamMetadataFormat, String nativeStreamMetadataFormatName, String nativeStreamMetadataFormatClassName, String[] extraStreamMetadataFormatNames, String[] extraStreamMetadataFormatClassNames, boolean supportsStandardImageMetadataFormat, String nativeImageMetadataFormatName, String nativeImageMetadataFormatClassName, String[] extraImageMetadataFormatNames, String[] extraImageMetadataFormatClassNames) {
        super("tidalwave.it", Version.TAG, names, suffixes, MIMETypes, readerClass.getName(), inputTypes, writerSpiNames, supportsStandardStreamMetadataFormat, nativeStreamMetadataFormatName, nativeStreamMetadataFormatClassName, extraStreamMetadataFormatNames, extraStreamMetadataFormatClassNames, supportsStandardImageMetadataFormat, nativeImageMetadataFormatName, nativeImageMetadataFormatClassName, extraImageMetadataFormatNames, extraImageMetadataFormatClassNames);
    }

    protected RAWImageReaderSpiSupport(String name, String[] suffixes, String mimeType, Class readerClass) {
        this(new String[]{name.toLowerCase(), name.toUpperCase()}, suffixes, new String[]{mimeType}, readerClass, new Class[]{ImageInputStream.class}, null, false, null, null, null, null, false, null, null, null, null);
    }

    protected RAWImageReaderSpiSupport(String name, String suffix, String mimeType, Class readerClass) {
        this(name, new String[]{suffix.toLowerCase(), suffix.toUpperCase()}, mimeType, readerClass);
    }

    public static void installPostProcessor(Class spiClass, PostProcessor postProcessor) {
        postProcessorMapBySpiClass.put(spiClass, postProcessor);
    }

    protected BufferedImage postProcess(BufferedImage image, RAWMetadataSupport metadata) {
        PostProcessor postProcessor = (PostProcessor)postProcessorMapBySpiClass.get(this.getClass());
        return postProcessor != null ? postProcessor.process(image, metadata) : image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canDecodeInput(Object source) throws IOException {
        if (source instanceof ImageInputStream) {
            return this.canDecodeInput((ImageInputStream)source);
        }
        ImageInputStream iis = null;
        try {
            iis = ImageIO.createImageInputStream(source);
            if (iis != null) {
                boolean bl = this.canDecodeInput(iis);
                return bl;
            }
        }
        finally {
            if (iis != null) {
                iis.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canDecodeInput(ImageInputStream source) throws IOException {
        RAWImageInputStream iis = new RAWImageInputStream(source);
        iis.setDontClose();
        try {
            iis.mark();
            boolean bl = this.canDecodeInput(iis);
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            iis.setBaseOffset(0L);
            iis.reset();
        }
    }

    protected abstract boolean canDecodeInput(RAWImageInputStream var1) throws IOException;
}

