/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.raw;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.raw.Directory;
import it.tidalwave.imageio.raw.HeaderProcessor;
import it.tidalwave.imageio.raw.RAWImageReaderSpiSupport;
import it.tidalwave.imageio.raw.RAWMetadataSupport;
import it.tidalwave.imageio.util.Logger;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RAWImageReaderSupport
extends ImageReader {
    private static final String CLASS = "it.tidalwave.imageio.raw.RAWImageReaderSupport";
    private static final Logger logger = Logger.getLogger("it.tidalwave.imageio.raw.RAWImageReaderSupport");
    protected RAWImageInputStream iis;
    private BufferedImage[] image;
    private BufferedImage[][] thumbnail;
    protected boolean metadataLoaded = false;
    protected RAWMetadataSupport metadata;
    protected Directory primaryDirectory;
    protected Directory makerNote;
    protected HeaderProcessor headerProcessor = new HeaderProcessor();

    protected RAWImageReaderSupport(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public final BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        logger.fine("read(%d, %s)", imageIndex, param);
        int imageCount = this.getNumImages(true);
        if (this.image == null) {
            this.image = new BufferedImage[imageCount];
        }
        if (imageIndex >= this.image.length) {
            throw new IllegalArgumentException("Bad imageIndex: " + imageIndex + " max is " + (imageCount - 1));
        }
        if (this.image[imageIndex] == null) {
            this.processImageStarted(imageIndex);
            this.processSequenceStarted(imageIndex);
            try {
                BufferedImage rawImage = this.loadImage(imageIndex);
                this.image[imageIndex] = ((RAWImageReaderSpiSupport)this.getOriginatingProvider()).postProcess(rawImage, this.metadata);
                this.processImageComplete();
            }
            catch (IOException e) {
                this.abort();
                this.processReadAborted();
                throw e;
            }
        }
        logger.info(">>>> read() completed ok", new Object[0]);
        return this.image[imageIndex];
    }

    @Override
    public final BufferedImage readThumbnail(int imageIndex, int thumbnailIndex) throws IOException {
        logger.info("readThumbnail(%d, %d)", imageIndex, thumbnailIndex);
        if (!this.readerSupportsThumbnails()) {
            throw new UnsupportedOperationException("Thumbnails not supported!");
        }
        int imageCount = this.getNumImages(true);
        if (imageIndex >= imageCount) {
            throw new IllegalArgumentException("Invalid imageIndex: " + imageIndex + " max is " + (imageCount - 1));
        }
        int thumbnailCount = this.getNumThumbnails(imageIndex);
        if (thumbnailIndex >= thumbnailCount) {
            throw new IllegalArgumentException("Invalid thumbnailIndex: " + thumbnailIndex + " max is " + (thumbnailCount - 1));
        }
        if (this.thumbnail == null) {
            this.thumbnail = new BufferedImage[imageCount][];
        }
        if (this.thumbnail[imageIndex] == null) {
            this.thumbnail[imageIndex] = new BufferedImage[thumbnailCount];
        }
        if (this.thumbnail[imageIndex][thumbnailIndex] == null) {
            this.processThumbnailStarted(imageIndex, thumbnailIndex);
            try {
                this.thumbnail[imageIndex][thumbnailIndex] = this.loadThumbnail(imageIndex, thumbnailIndex);
                this.processThumbnailComplete();
            }
            catch (IOException e) {
                this.abort();
                this.processReadAborted();
                throw e;
            }
        }
        logger.info(">>>> readThumbnail() completed ok", new Object[0]);
        return this.thumbnail[imageIndex][thumbnailIndex];
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        if (this.metadata == null) {
            try {
                this.metadata = this.loadMetadata(imageIndex);
            }
            catch (IOException e) {
                this.abort();
                throw e;
            }
        }
        return this.metadata;
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        this.disposeAll();
        input = this.wrapInput(input);
        if (input != null) {
            logger.finer("Wrapped input is: %s", input.getClass());
        }
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        this.iis = (RAWImageInputStream)input;
    }

    @Override
    public final void reset() {
        logger.fine("reset()", new Object[0]);
        super.reset();
        this.disposeAll();
    }

    @Override
    public final void dispose() {
        logger.fine("dispose()", new Object[0]);
        super.dispose();
        this.disposeAll();
    }

    @Override
    public void processImageProgress(float progress) {
        super.processImageProgress(progress);
    }

    @Override
    public boolean readerSupportsThumbnails() {
        return true;
    }

    @Override
    public int getNumImages(boolean allowSearch) {
        return 1;
    }

    @Override
    @Nonnull
    public Iterator<ImageTypeSpecifier> getImageTypes(@Nonnegative int imageIndex) {
        this.checkImageIndex(imageIndex);
        ArrayList<ImageTypeSpecifier> imageTypes = new ArrayList<ImageTypeSpecifier>();
        ColorSpace rgb = ColorSpace.getInstance(1004);
        boolean type = true;
        int[] bandOffsets = new int[]{0, 1, 2};
        ImageTypeSpecifier imageType = ImageTypeSpecifier.createInterleaved(rgb, bandOffsets, 1, false, false);
        imageTypes.add(imageType);
        return imageTypes.iterator();
    }

    @Override
    public IIOMetadata getStreamMetadata() {
        return null;
    }

    protected BufferedImage loadImage(int imageIndex) throws IOException {
        logger.fine("loadImage(%d) - iis: %s", imageIndex, this.iis);
        this.checkImageIndex(imageIndex);
        this.ensureMetadataIsLoaded(imageIndex);
        return this.loadRAWImage();
    }

    protected abstract BufferedImage loadThumbnail(int var1, int var2) throws IOException;

    protected abstract WritableRaster loadRAWRaster() throws IOException;

    protected abstract RAWMetadataSupport createMetadata(Directory var1, Directory var2);

    protected abstract Directory loadPrimaryDirectory() throws IOException;

    protected abstract void processMetadata() throws IOException;

    protected Object wrapInput(Object input) {
        return new RAWImageInputStream((ImageInputStream)input);
    }

    protected void failure(String message) {
        this.abortRequested();
        throw new RuntimeException(message);
    }

    protected final BufferedImage createImage(int transferType, ColorSpace colorSpace, WritableRaster raster) {
        ComponentColorModel colorModel = new ComponentColorModel(colorSpace, false, false, 1, transferType);
        Properties properties = new Properties();
        return new BufferedImage(colorModel, raster, false, properties);
    }

    protected void disposeAll() {
        this.image = null;
        this.thumbnail = null;
        this.metadata = null;
        this.primaryDirectory = null;
        this.makerNote = null;
        this.metadataLoaded = false;
    }

    protected void checkImageIndex(int imageIndex) {
        if (imageIndex > 0) {
            throw new IndexOutOfBoundsException("Invalid image index: " + imageIndex);
        }
    }

    protected void ensureMetadataIsLoaded(int imageIndex) throws IOException {
        if (!this.metadataLoaded) {
            this.loadMetadata(imageIndex);
            this.checkMetadataIsLoaded();
        }
    }

    protected void checkMetadataIsLoaded() {
        if (!this.metadataLoaded) {
            throw new IllegalStateException("Metadata was not read yet");
        }
    }

    protected final BufferedImage loadRAWImage() throws IOException {
        logger.fine("loadRAWImage() - iis: %s", this.iis);
        WritableRaster raster = this.loadRAWRaster();
        int dataType = raster.getDataBuffer().getDataType();
        BufferedImage bufferedImage = this.createImage(dataType, this.getColorSpace(), raster);
        logger.fine(">>>> loadRAWImage() completed ok", new Object[0]);
        return bufferedImage;
    }

    protected ColorSpace getColorSpace() {
        return ColorSpace.getInstance(1004);
    }

    protected synchronized RAWMetadataSupport loadMetadata(int imageIndex) throws IOException {
        logger.fine("loadMetadata(%d) - iis: %s", imageIndex, this.iis);
        this.checkImageIndex(imageIndex);
        if (!this.metadataLoaded) {
            this.processMetadata();
            this.metadataLoaded = true;
        }
        logger.fine(">>>> loadMetadata() completed ok", new Object[0]);
        return this.metadata;
    }

    protected static BufferedImage loadEmbeddedImage(ImageInputStream iis, int offset, int length) throws IOException {
        logger.fine("loadEmbeddedImage(%s, %d, %d)", iis, offset, length);
        long time = System.currentTimeMillis();
        byte[] buffer = new byte[length];
        iis.seek(offset);
        iis.read(buffer, 0, length);
        ByteArrayInputStream is = new ByteArrayInputStream(buffer);
        BufferedImage image = ImageIO.read(is);
        is.close();
        logger.fine(">>>> loadEmbeddedImage() completed ok in %d msec, returning %s", System.currentTimeMillis() - time, image);
        return image;
    }
}

