/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.raw;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.raw.RAWImageReaderSupport;
import it.tidalwave.imageio.util.Logger;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.annotation.Nonnull;

public class RasterReader {
    private static final String CLASS = RasterReader.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    public static final int R_OFFSET = 0;
    public static final int G_OFFSET = 1;
    public static final int B_OFFSET = 2;
    private int width;
    private int height;
    protected int bitsPerSample = -1;
    protected int[] cfaOffsets;
    protected int stripByteCount = -1;
    protected int tileWidth;
    protected int tileHeight;
    protected int tilesAcross;
    protected int tilesDown;
    protected int[] tileOffsets;
    protected int[] linearizationTable;
    protected int compression = -1;
    protected long rasterOffset;
    protected ByteOrder byteOrder;

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setCFAPattern(byte[] cfaPattern) {
        int size = cfaPattern.length;
        if (size != 4 && size != 8) {
            throw new IllegalArgumentException("Badly sized CFA data");
        }
        this.cfaOffsets = new int[4];
        int base = size == 4 ? 0 : 4;
        for (int i = 0; i < this.cfaOffsets.length; ++i) {
            int o;
            for (o = cfaPattern[i + base]; o > 3; o -= 3) {
            }
            this.cfaOffsets[i] = o;
        }
    }

    public void setBitsPerSample(int bitsPerSample) {
        this.bitsPerSample = bitsPerSample;
    }

    public void setTileWidth(int tileWidth) {
        this.tileWidth = tileWidth;
    }

    public void setTileHeight(int tileHeight) {
        this.tileHeight = tileHeight;
    }

    public void setTilesAcross(int tilesAcross) {
        this.tilesAcross = tilesAcross;
    }

    public void setTilesDown(int tilesDown) {
        this.tilesDown = tilesDown;
    }

    public void setTileOffsets(int[] tileOffsets) {
        this.tileOffsets = tileOffsets;
    }

    public void setRasterOffset(long rasterOffset) {
        this.rasterOffset = rasterOffset;
    }

    public void setStripByteCount(int stripByteCount) {
        this.stripByteCount = stripByteCount;
    }

    public void setCompression(int compression) {
        this.compression = compression;
    }

    public void setLinearizationTable(int[] linearizationTable) {
        if (linearizationTable == null) {
            this.linearizationTable = null;
        } else {
            this.linearizationTable = new int[65536];
            int length = linearizationTable.length;
            System.arraycopy(linearizationTable, 0, this.linearizationTable, 0, length);
            for (int i = length; i < this.linearizationTable.length; ++i) {
                this.linearizationTable[i] = linearizationTable[length - 1];
            }
        }
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public final WritableRaster loadRaster(RAWImageInputStream iis, RAWImageReaderSupport ir) throws IOException {
        assert (this.width > 0) : "width not set";
        assert (this.height > 0) : "height not set";
        assert (this.bitsPerSample > 0) : "bitsPerSample not set";
        assert (this.stripByteCount > 0 || this.tileOffsets.length > 0) : "strips or tiles not set";
        assert (this.compression != -1) : "compression not set";
        WritableRaster raster = this.createRaster();
        if (this.isCompressedRaster()) {
            this.loadCompressedRaster(iis, raster, ir);
        } else {
            this.loadUncompressedRaster(iis, raster, ir);
        }
        return raster;
    }

    protected void loadUncompressedRaster(RAWImageInputStream iis, WritableRaster raster, RAWImageReaderSupport ir) throws IOException {
        if (this.bitsPerSample == 16) {
            if (this.cfaOffsets != null) {
                this.loadUncompressedRaster16(iis, raster, ir);
            } else {
                this.loadRGBUncompressedRasterNot16(iis, raster, ir);
            }
        } else if (this.cfaOffsets != null) {
            this.loadUncompressedRasterNot16(iis, raster, ir);
        } else {
            this.loadRGBUncompressedRasterNot16(iis, raster, ir);
        }
    }

    protected void loadUncompressedRasterNot16(RAWImageInputStream iis, WritableRaster raster, RAWImageReaderSupport ir) throws IOException {
        logger.fine("loadUncompressedRaster()", new Object[0]);
        logger.finer(">>>> CFA pattern: %d %d %d %d", this.cfaOffsets[0], this.cfaOffsets[1], this.cfaOffsets[2], this.cfaOffsets[3]);
        DataBufferUShort dataBuffer = (DataBufferUShort)raster.getDataBuffer();
        short[] data = dataBuffer.getData();
        int width = raster.getWidth();
        int height = raster.getHeight();
        int pixelStride = 3;
        int scanStride = width * pixelStride;
        this.selectBitReader(iis, raster, this.bitsPerSample);
        for (int y = 0; y < height; ++y) {
            int row = this.getRow(y, height);
            int i = row * scanStride;
            int k = row % 2 * 2;
            for (int x = 0; x < width; ++x) {
                iis.skipBits(this.getSkipCountAtColumn(x));
                int j = x % 2;
                int sample = (int)iis.readBits(this.bitsPerSample);
                if (this.linearizationTable != null) {
                    sample = this.linearizationTable[sample];
                }
                data[i + this.cfaOffsets[j + k]] = (short)sample;
                i += pixelStride;
            }
            iis.skipBits(this.getSkipCountAtEndOfRow(y, height));
            ir.processImageProgress(100.0f * (float)y / (float)height);
        }
    }

    protected void loadRGBUncompressedRasterNot16(RAWImageInputStream iis, WritableRaster raster, RAWImageReaderSupport ir) throws IOException {
        logger.fine("loadRGBUncompressedRasterNot16()", new Object[0]);
        DataBufferUShort dataBuffer = (DataBufferUShort)raster.getDataBuffer();
        short[] data = dataBuffer.getData();
        int width = raster.getWidth();
        int height = raster.getHeight();
        int pixelStride = 3;
        int scanStride = width * pixelStride;
        this.selectBitReader(iis, raster, this.bitsPerSample);
        for (int y = 0; y < height; ++y) {
            int row = this.getRow(y, height);
            int i = row * scanStride;
            for (int x = 0; x < width; ++x) {
                iis.skipBits(this.getSkipCountAtColumn(x));
                for (int c = 0; c < 3; ++c) {
                    int sample = (int)iis.readBits(this.bitsPerSample);
                    if (this.linearizationTable != null) {
                        sample = this.linearizationTable[sample];
                    }
                    data[i++] = (short)sample;
                }
            }
            iis.skipBits(this.getSkipCountAtEndOfRow(y, height));
            ir.processImageProgress(100.0f * (float)y / (float)height);
        }
    }

    protected void loadUncompressedRaster16(@Nonnull RAWImageInputStream iis, @Nonnull WritableRaster raster, @Nonnull RAWImageReaderSupport ir) throws IOException {
        long position = iis.getStreamPosition();
        logger.fine(String.format("loadUncompressedRaster16() at %d (0x%x), %d x %d %dbps", position, position, this.width, this.height, this.bitsPerSample), new Object[0]);
        logger.finer(">>>> CFA pattern: %d %d %d %d", this.cfaOffsets[0], this.cfaOffsets[1], this.cfaOffsets[2], this.cfaOffsets[3]);
        DataBufferUShort dataBuffer = (DataBufferUShort)raster.getDataBuffer();
        short[] data = dataBuffer.getData();
        int width = raster.getWidth();
        int height = raster.getHeight();
        int pixelStride = 3;
        int scanStride = width * 3;
        this.selectBitReader(iis, raster, this.bitsPerSample);
        if (this.byteOrder == null) {
            this.byteOrder = iis.getByteOrder();
        }
        logger.finer(">>>> byte order: %s", this.byteOrder);
        boolean swap16 = this.byteOrder == ByteOrder.BIG_ENDIAN;
        for (int y = 0; y < height; ++y) {
            int row = this.getRow(y, height);
            int i = row * scanStride;
            int k = row % 2 * 2;
            for (int x = 0; x < width; ++x) {
                int j = x % 2;
                int sample = (int)iis.readBits(this.bitsPerSample) & 0xFFFF;
                if (swap16) {
                    sample = (sample >>> 8 | sample << 8) & 0xFFFF;
                }
                data[i + this.cfaOffsets[j + k]] = (short)sample;
                i += 3;
            }
            ir.processImageProgress(100.0f * (float)y / (float)height);
        }
        position = iis.getStreamPosition();
        logger.fine(String.format(">>>> loadUncompressedRaster16() completed at %d (0x%x)", position, position), new Object[0]);
    }

    protected void loadCompressedRaster(RAWImageInputStream iis, WritableRaster raster, RAWImageReaderSupport ir) throws IOException {
    }

    protected final WritableRaster createRaster() {
        int bandCount;
        boolean type = true;
        int[] bandOffsets = this.getBandOffsets();
        int pixelStride = bandCount = bandOffsets.length;
        int scanlineStride = pixelStride * this.width;
        return Raster.createInterleavedRaster(1, this.width, this.height, scanlineStride, pixelStride, bandOffsets, null);
    }

    protected void selectBitReader(RAWImageInputStream iis, WritableRaster raster, int bitsPerSample) {
        DataBufferUShort dataBuffer = (DataBufferUShort)raster.getDataBuffer();
        int typeBits = DataBuffer.getDataTypeSize(dataBuffer.getDataType());
        if (this.isCompressedRaster()) {
            iis.selectBitReader(-1, 0);
        } else if (bitsPerSample == 12 && this.stripByteCount % this.height == 0) {
            iis.selectBitReader(12, this.stripByteCount / this.height);
        } else if (bitsPerSample == 16) {
            iis.selectBitReader(16, this.width * typeBits / 16);
        } else {
            iis.selectBitReader(-1, 0);
        }
    }

    protected boolean isCompressedRaster() {
        return false;
    }

    protected int getRow(int interlacedRow, int height) {
        return interlacedRow;
    }

    protected int getSkipCountAtColumn(int x) {
        return 0;
    }

    protected int getSkipCountAtEndOfRow(int y, int height) {
        return 0;
    }

    protected int[] getBandOffsets() {
        return new int[]{0, 1, 2};
    }
}

