/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor;

import it.tidalwave.imageio.raw.PostProcessor;
import it.tidalwave.imageio.raw.RAWMetadataSupport;
import it.tidalwave.imageio.rawprocessor.Operation;
import it.tidalwave.imageio.rawprocessor.OperationSupport;
import it.tidalwave.imageio.rawprocessor.RAWImage;
import it.tidalwave.imageio.util.Logger;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RAWProcessor
implements PostProcessor {
    private static final String CLASS = RAWProcessor.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private final List<OperationSupport> operationList = new ArrayList<OperationSupport>();

    public RAWProcessor() {
        this.buildPipeline(this.operationList);
    }

    protected abstract void buildPipeline(@Nonnull List<OperationSupport> var1);

    @Override
    public final BufferedImage process(BufferedImage image, RAWMetadataSupport metadata) {
        logger.fine("POSTPROCESSING...", new Object[0]);
        RAWImage rawImage = new RAWImage(image, metadata);
        this.init(rawImage);
        this.process(rawImage);
        return rawImage.getImage();
    }

    private final void init(RAWImage rawImage) {
        for (Operation operation : this.operationList) {
            logger.fine(">>> Initializing: %s", operation.getClass());
            try {
                operation.init(rawImage);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private final void process(RAWImage rawImage) {
        for (Operation operation : this.operationList) {
            String operationName = operation.getClass().getName();
            try {
                long time = System.currentTimeMillis();
                logger.info("Executing: %s", operationName);
                operation.process(rawImage);
                time = System.currentTimeMillis() - time;
                logger.fine(">>>> %s completed ok in %d msec", operationName, time);
            }
            catch (Exception e) {
                logger.warning("%s FAILED", operationName);
                throw new RuntimeException(e);
            }
        }
    }
}

