/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.cr2;

import it.tidalwave.imageio.cr2.CanonCR2MakerNote;
import it.tidalwave.imageio.rawprocessor.OperationSupport;
import it.tidalwave.imageio.rawprocessor.RAWImage;
import it.tidalwave.imageio.util.Logger;

public class CR2WhiteBalanceOperation
extends OperationSupport {
    private static final Logger logger = CR2WhiteBalanceOperation.getLogger(CR2WhiteBalanceOperation.class);

    public void process(RAWImage image) {
        logger.fine("process()", new Object[0]);
        CanonCR2MakerNote cr2Makernote = (CanonCR2MakerNote)image.getRAWMetadata().getMakerNote();
        short[] coefficients = cr2Makernote.getWhiteBalanceCoefficients();
        double scale = 9.765625E-4;
        image.multiplyRedCoefficient(scale * (double)coefficients[0]);
        image.multiplyGreenCoefficient(scale * (double)coefficients[1]);
        image.multiplyBlueCoefficient(scale * (double)coefficients[3]);
    }
}

