/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.crw;

import it.tidalwave.imageio.crw.CRWMetadata;
import it.tidalwave.imageio.rawprocessor.RAWImage;
import it.tidalwave.imageio.rawprocessor.raw.SizeOperation;
import it.tidalwave.imageio.util.Logger;
import java.awt.Dimension;
import java.awt.Insets;

public class CRWSizeOperation
extends SizeOperation {
    private static final Logger logger = CRWSizeOperation.getLogger(CRWSizeOperation.class);

    protected Insets getCrop(RAWImage image) {
        logger.fine("getCrop()", new Object[0]);
        CRWMetadata metadata = (CRWMetadata)image.getRAWMetadata();
        int l = metadata.getSensorLeftBorder();
        int t = metadata.getSensorTopBorder();
        int r = metadata.getSensorWidth() - metadata.getSensorRightBorder() - 1;
        int b = metadata.getSensorHeight() - metadata.getSensorBottomBorder() - 1;
        Insets crop = new Insets(t, l, b, r);
        logger.fine(">>>> returning: %s", crop);
        return crop;
    }

    protected Dimension getSize(RAWImage image) {
        logger.fine("getSize()", new Object[0]);
        CRWMetadata crwMetadata = (CRWMetadata)image.getRAWMetadata();
        Dimension dimension = new Dimension(crwMetadata.getImageWidth(), crwMetadata.getImageHeight());
        logger.fine(">>>> returning: %s", dimension);
        return dimension;
    }
}

