/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.demosaic;

import it.tidalwave.imageio.rawprocessor.Curve;
import it.tidalwave.imageio.rawprocessor.demosaic.BayerInfo;
import it.tidalwave.imageio.rawprocessor.demosaic.DemosaicingFilter;
import it.tidalwave.imageio.util.Logger;
import java.awt.image.BufferedImage;

public class DemosaicFilterProcessor {
    private static final String CLASS = "it.tidalwave.imageio.rawprocessor.demosaic.DemosaicFilterProcessor";
    private static final Logger logger = Logger.getLogger("it.tidalwave.imageio.rawprocessor.demosaic.DemosaicFilterProcessor");
    private DemosaicingFilter filter;
    private BayerInfo bayerInfo;
    private double redCoeff = 1.0;
    private double greenCoeff = 1.0;
    private double blueCoeff = 1.0;
    private double blackLevel = 0.0;
    private Curve curve;

    public DemosaicFilterProcessor(String bayerPattern, String algorithm, double redCoeff, double greenCoeff, double blueCoeff, double blackLevel, Curve curve) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String packageName = this.getClass().getPackage().getName();
        try {
            Class<?> bayerInfoClass = Class.forName(packageName + ".BayerInfo_" + bayerPattern);
            Class<?> filterClass = Class.forName(packageName + "." + algorithm + "DemosaicingFilter");
            this.bayerInfo = (BayerInfo)bayerInfoClass.newInstance();
            this.filter = (DemosaicingFilter)filterClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            Class<?> filterClass = Class.forName(packageName + "." + "DemosaicingFilter_" + bayerPattern);
            this.filter = (DemosaicingFilter)filterClass.newInstance();
        }
        this.redCoeff = redCoeff;
        this.greenCoeff = greenCoeff;
        this.blueCoeff = blueCoeff;
        this.blackLevel = blackLevel;
        this.curve = curve;
    }

    public void process(BufferedImage image) {
        logger.info("Demosaicing: R: %f, G: %f, B: %f, black: %f, Curve: %s", this.redCoeff, this.greenCoeff, this.blueCoeff, this.blackLevel, this.curve);
        if (this.bayerInfo != null) {
            this.bayerInfo.setSampleModel(image.getSampleModel());
        }
        this.filter.setRedCoefficient(this.redCoeff);
        this.filter.setGreenCoefficient(this.greenCoeff);
        this.filter.setBlueCoefficient(this.blueCoeff);
        this.filter.setBlackLevel((int)this.blackLevel);
        if (this.curve != null) {
            this.filter.setCurve(this.curve.resize(65536).getSamples());
        }
        this.filter.filter(image.getRaster(), this.bayerInfo);
    }
}

