/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.dng;

import it.tidalwave.imageio.raw.TagRational;
import it.tidalwave.imageio.rawprocessor.OperationSupport;
import it.tidalwave.imageio.rawprocessor.RAWImage;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.TIFFMetadataSupport;
import it.tidalwave.imageio.util.Logger;

public class DNGWhiteBalanceOperation
extends OperationSupport {
    private static final Logger logger = DNGWhiteBalanceOperation.getLogger(DNGWhiteBalanceOperation.class);

    public void process(RAWImage image) {
        TagRational[] asn;
        TIFFMetadataSupport metadata = (TIFFMetadataSupport)image.getRAWMetadata();
        IFD primaryIFD = metadata.getPrimaryIFD();
        if (primaryIFD.isAsShotNeutralAvailable()) {
            asn = primaryIFD.getAsShotNeutral();
            image.multiplyRedCoefficient(asn[0].reciprocal().doubleValue());
            image.multiplyGreenCoefficient(asn[1].reciprocal().doubleValue());
            image.multiplyBlueCoefficient(asn[2].reciprocal().doubleValue());
        }
        if (primaryIFD.isAnalogBalanceAvailable()) {
            asn = primaryIFD.getAnalogBalance();
            image.multiplyRedCoefficient(asn[0].reciprocal().doubleValue());
            image.multiplyGreenCoefficient(asn[1].reciprocal().doubleValue());
            image.multiplyBlueCoefficient(asn[2].reciprocal().doubleValue());
        }
    }
}

