/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.mrw;

import it.tidalwave.imageio.minolta.MinoltaRawData;
import it.tidalwave.imageio.mrw.MRWMetadata;
import it.tidalwave.imageio.rawprocessor.RAWImage;
import it.tidalwave.imageio.rawprocessor.raw.SizeOperation;
import it.tidalwave.imageio.util.Logger;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.annotation.Nonnull;

public class MRWSizeOperation
extends SizeOperation {
    private static final Logger logger = MRWSizeOperation.getLogger(MRWSizeOperation.class);

    @Nonnull
    protected Insets getCrop(@Nonnull RAWImage image) {
        MRWMetadata metadata = (MRWMetadata)image.getRAWMetadata();
        MinoltaRawData.PRD prd = metadata.getMinoltaRawData().getPRD();
        BufferedImage bufferedImage = image.getImage();
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        Dimension newSize = prd.getImageSize();
        return new Insets((height - newSize.height) / 2, (width - newSize.width) / 2, (height - newSize.height) / 2, (width - newSize.width) / 2);
    }
}

