/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.nef;

import it.tidalwave.imageio.nef.NEFMetadata;
import it.tidalwave.imageio.nef.Nikon3MakerNoteSupport;
import it.tidalwave.imageio.nef.NikonMakerNote3;
import it.tidalwave.imageio.rawprocessor.ColorMatrix;
import it.tidalwave.imageio.rawprocessor.RAWImage;
import it.tidalwave.imageio.rawprocessor.raw.ColorConversionOperation;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.util.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class NEFColorConversionOperation
extends ColorConversionOperation {
    private static final Logger logger = NEFColorConversionOperation.getLogger(NEFColorConversionOperation.class);
    private static Map colorMatrixProfileMap;
    private static Map colorModesMap;

    protected ColorMatrix getColorMatrixXYZ(RAWImage image) {
        NEFMetadata metadata = (NEFMetadata)image.getRAWMetadata();
        IFD primaryIFD = metadata.getPrimaryIFD();
        NikonMakerNote3 makerNote = metadata.getNikonMakerNote();
        if (makerNote.isColorModeAvailable()) {
            ColorMatrix colorMatrix = NEFColorConversionOperation.getColorModeColorMatrix(primaryIFD.getModel(), makerNote.getColorMode());
            logger.finer(">>>> model: %s colorMode: %s matrixXYZ: %s", primaryIFD.getModel(), makerNote.getColorMode(), colorMatrix);
            return colorMatrix;
        }
        return null;
    }

    private static ColorMatrix parseColorMatrix(String string) {
        int j = string.indexOf(35);
        if (j >= 0) {
            string = string.substring(0, j);
        }
        String[] parts = string.trim().split(" ");
        assert (parts.length == 9);
        double[] c = new double[9];
        for (int i = 0; i < c.length; ++i) {
            c[i] = Double.parseDouble(parts[i].trim());
        }
        return new ColorMatrix(c);
    }

    public static ColorMatrix getColorModeColorMatrix(String model, Nikon3MakerNoteSupport.ColorMode cameraColorMode) {
        NEFColorConversionOperation.loadICCProfileMap();
        return (ColorMatrix)colorMatrixProfileMap.get(NEFColorConversionOperation.getCompositeKey(model, cameraColorMode));
    }

    public static ColorMatrix getColorModeColorMatrix(String model, int nceColorMode) {
        NEFColorConversionOperation.loadICCProfileMap();
        return (ColorMatrix)colorMatrixProfileMap.get(NEFColorConversionOperation.getCompositeKey(model, new Integer(nceColorMode)));
    }

    public static int[] getColorModes(String model) {
        NEFColorConversionOperation.loadICCProfileMap();
        return (int[])colorModesMap.get(model);
    }

    private static Object getCompositeKey(String model, Object colorMode) {
        return model.toString().trim() + "." + colorMode.toString().trim();
    }

    private static void loadICCProfileMap() {
        if (colorMatrixProfileMap == null) {
            colorMatrixProfileMap = new HashMap();
            colorModesMap = new HashMap();
            Properties properties = NEFColorConversionOperation.getProperties(NEFColorConversionOperation.class);
            String property = properties.getProperty("models");
            if (property != null) {
                String[] models = property.split(",");
                for (int j = 0; j < models.length; ++j) {
                    String model;
                    String prefix = model = models[j].trim();
                    String alias = properties.getProperty(model + ".alias");
                    if (alias != null) {
                        prefix = alias;
                    }
                    String[] colorModeNames = properties.getProperty(prefix + ".colorModes").split(",");
                    int[] colorModes = new int[colorModeNames.length];
                    for (int i = 0; i < colorModes.length; ++i) {
                        String colorMode = colorModeNames[i].trim();
                        Integer nceCode = new Integer(properties.getProperty(prefix + "." + colorMode + ".nceCode"));
                        colorModes[i] = nceCode;
                        ColorMatrix colorMatrix = null;
                        String colorMatrixString = properties.getProperty(prefix + "." + colorMode + ".colorMatrix");
                        if (colorMatrixString != null) {
                            colorMatrix = NEFColorConversionOperation.parseColorMatrix(colorMatrixString);
                            colorMatrixProfileMap.put(NEFColorConversionOperation.getCompositeKey(model, nceCode), colorMatrix);
                            colorMatrixProfileMap.put(NEFColorConversionOperation.getCompositeKey(model, colorMode), colorMatrix);
                        }
                        logger.info("Model: %s, colorMode: %s, nce code: %s", model, colorMode, nceCode);
                        logger.info(">>>> Color matrix:   %s", colorMatrix);
                    }
                    colorModesMap.put(model, colorModes);
                }
            }
        }
    }
}

