/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.nef;

import it.tidalwave.imageio.nef.NEFMetadata;
import it.tidalwave.imageio.nef.NikonMakerNote3;
import it.tidalwave.imageio.rawprocessor.RAWImage;
import it.tidalwave.imageio.rawprocessor.raw.CurveOperation;
import it.tidalwave.imageio.util.Logger;

public class NEFCurveOperation
extends CurveOperation {
    private static final Logger logger = NEFCurveOperation.getLogger(NEFCurveOperation.class);

    protected double getWhiteLevel(RAWImage image) {
        double whiteLevel;
        logger.fine("getWhiteLevel()", new Object[0]);
        NEFMetadata metadata = (NEFMetadata)image.getRAWMetadata();
        NikonMakerNote3 makerNote = metadata.getNikonMakerNote();
        if (makerNote.isCompressionDataAvailable()) {
            int[] linearizationTable = makerNote.getLinearizationTable();
            whiteLevel = linearizationTable[linearizationTable.length - 1];
            logger.finer(">>>> whiteLevel from linearizationTable: %s", whiteLevel);
        } else {
            whiteLevel = super.getWhiteLevel(image);
        }
        return whiteLevel;
    }
}

