/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.nef;

import it.tidalwave.imageio.nef.NEFMetadata;
import it.tidalwave.imageio.nef.NikonCaptureEditorMetadata;
import it.tidalwave.imageio.nef.NikonMakerNote3;
import it.tidalwave.imageio.rawprocessor.OperationSupport;
import it.tidalwave.imageio.rawprocessor.RAWImage;
import it.tidalwave.imageio.rawprocessor.RAWProcessor;
import it.tidalwave.imageio.rawprocessor.nef.NEFColorConversionOperation;
import it.tidalwave.imageio.rawprocessor.nef.NEFCurveOperation;
import it.tidalwave.imageio.rawprocessor.nef.NEFExposureOperation;
import it.tidalwave.imageio.rawprocessor.nef.NEFRotateOperation;
import it.tidalwave.imageio.rawprocessor.nef.NEFSizeOperation;
import it.tidalwave.imageio.rawprocessor.nef.NEFWhiteBalanceOperation;
import it.tidalwave.imageio.rawprocessor.raw.ColorProfileOperation;
import it.tidalwave.imageio.rawprocessor.raw.DemosaicOperation;
import it.tidalwave.imageio.util.Logger;
import java.util.List;
import javax.annotation.Nonnull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NEFProcessor
extends RAWProcessor {
    private static final String CLASS = NEFProcessor.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    @Override
    protected void buildPipeline(@Nonnull List<OperationSupport> operationList) {
        operationList.add(new BindNCEMetadata());
        operationList.add(new NEFWhiteBalanceOperation());
        operationList.add(new NEFExposureOperation());
        operationList.add(new NEFCurveOperation());
        operationList.add(new DemosaicOperation());
        operationList.add(new NEFRotateOperation());
        operationList.add(new NEFSizeOperation());
        operationList.add(new NEFColorConversionOperation());
        operationList.add(new ColorProfileOperation());
    }

    class BindNCEMetadata
    extends OperationSupport {
        BindNCEMetadata() {
        }

        public void init(@Nonnull RAWImage image) throws Exception {
            NEFMetadata metadata = (NEFMetadata)image.getRAWMetadata();
            NikonMakerNote3 makerNote = metadata.getNikonMakerNote();
            if (makerNote.isCaptureEditorDataAvailable()) {
                NikonCaptureEditorMetadata nceMetadata = new NikonCaptureEditorMetadata(makerNote.getCaptureEditorData());
                logger.finer(nceMetadata.toString(), new Object[0]);
                metadata._setCaptureEditorMetadata(nceMetadata);
            }
        }

        public void process(@Nonnull RAWImage image) throws Exception {
        }
    }
}

