/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.nef;

import it.tidalwave.imageio.nef.NEFMetadata;
import it.tidalwave.imageio.nef.NikonCaptureEditorMetadata;
import it.tidalwave.imageio.rawprocessor.RAWImage;
import it.tidalwave.imageio.rawprocessor.raw.SizeOperation;
import it.tidalwave.imageio.util.Logger;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.annotation.Nonnull;

public class NEFSizeOperation
extends SizeOperation {
    private static final Logger logger = NEFSizeOperation.getLogger(NEFSizeOperation.class);

    @Nonnull
    protected Insets getCrop(@Nonnull RAWImage image) {
        logger.fine("getCrop()", new Object[0]);
        Insets crop = super.getCrop(image);
        int rotation = this.normalizedAngle(image.getRotation());
        crop = NEFSizeOperation.rotate(crop, rotation);
        logger.finer(String.format(">>>> rotation: %d, crop: %s", rotation, crop), new Object[0]);
        NEFMetadata metadata = (NEFMetadata)image.getRAWMetadata();
        NikonCaptureEditorMetadata nceMetadata = (NikonCaptureEditorMetadata)metadata.getCaptureEditorMetadata();
        if (nceMetadata != null) {
            double scale = 0.5;
            Rectangle nceCrop = new Rectangle(0, 0, 0, 0);
            nceCrop.x = (int)Math.round(nceMetadata.getCropLeft() * scale);
            nceCrop.y = (int)Math.round(nceMetadata.getCropTop() * scale);
            nceCrop.width = (int)Math.round(nceMetadata.getCropWidth() * scale);
            nceCrop.height = (int)Math.round(nceMetadata.getCropHeight() * scale);
            if (metadata.getPrimaryIFD().getModel().trim().equals("NIKON D1X")) {
                nceCrop.height /= 2;
            }
            Dimension size = this.getSize(image);
            logger.fine(String.format(">>>> original size: %s, original NCE crop: %s", size, nceCrop), new Object[0]);
            boolean shouldRotateNCECrop = true;
            if (shouldRotateNCECrop) {
                Rectangle save = (Rectangle)nceCrop.clone();
                nceCrop = NEFSizeOperation.rotate(nceCrop, size, rotation);
                if (nceCrop.x < 0 || nceCrop.y < 0) {
                    logger.warning("Bad crop, NCE crop hadn't to be rotated", new Object[0]);
                    nceCrop = save;
                }
            }
            if (rotation == 90 || rotation == 270) {
                int tmp = size.width;
                size.width = size.height;
                size.height = tmp;
            }
            logger.fine(String.format(">>>> size: %s, NCE crop: %s", size, nceCrop), new Object[0]);
            crop.left += nceCrop.x;
            crop.top += nceCrop.y;
            crop.right += size.width - nceCrop.width;
            crop.bottom += size.height - nceCrop.height;
        }
        logger.fine(">>>> returning crop: %s", crop);
        return crop;
    }
}

