/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.orf;

import it.tidalwave.imageio.orf.OlympusMakerNote;
import it.tidalwave.imageio.rawprocessor.RAWImage;
import it.tidalwave.imageio.rawprocessor.raw.CurveOperation;
import it.tidalwave.imageio.tiff.TIFFMetadataSupport;
import javax.annotation.Nonnull;

public class ORFCurveOperation
extends CurveOperation {
    private int[] blackLevels;
    private int validBits;

    public void init(@Nonnull RAWImage image) throws Exception {
        this.validBits = 12;
        OlympusMakerNote orfMakernote = (OlympusMakerNote)image.getRAWMetadata().getMakerNote();
        String model = ((TIFFMetadataSupport)image.getRAWMetadata()).getPrimaryIFD().getModel();
        if ("E-1".equals(model = model.toUpperCase().trim()) || "E-10".equals(model)) {
            this.validBits = 16;
        }
        this.blackLevels = new int[]{0, 0, 0};
    }

    @Nonnull
    protected int[] getBlackLevel(@Nonnull RAWImage image) {
        return this.blackLevels;
    }

    protected double getWhiteLevel(@Nonnull RAWImage image) {
        double whiteLevel = (1 << this.validBits) - 1;
        return whiteLevel;
    }
}

