/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.orf;

import it.tidalwave.imageio.orf.ImageProcessing;
import it.tidalwave.imageio.orf.OlympusMakerNote;
import it.tidalwave.imageio.rawprocessor.OperationSupport;
import it.tidalwave.imageio.rawprocessor.RAWImage;
import it.tidalwave.imageio.util.Logger;
import javax.annotation.Nonnull;

public class ORFWhiteBalanceOperation
extends OperationSupport {
    private static final String CLASS = ORFWhiteBalanceOperation.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    public void process(@Nonnull RAWImage image) {
        ImageProcessing imageProcessing;
        logger.fine("process()", new Object[0]);
        OlympusMakerNote orfMakernote = (OlympusMakerNote)image.getRAWMetadata().getMakerNote();
        if (orfMakernote != null && (imageProcessing = orfMakernote.getOlympusImageProcessing()) != null && imageProcessing.isRBCoefficientsAvailable()) {
            int[] rbCoefficients = imageProcessing.getRBCoefficients();
            image.multiplyRedCoefficient((double)rbCoefficients[0] / 256.0);
            image.multiplyBlueCoefficient((double)rbCoefficients[1] / 256.0);
        }
    }
}

