/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.pef;

import it.tidalwave.imageio.pef.PentaxMakerNote;
import it.tidalwave.imageio.rawprocessor.RAWImage;
import it.tidalwave.imageio.rawprocessor.raw.SizeOperation;
import java.awt.Dimension;
import java.awt.Insets;

public class PEFSizeOperation
extends SizeOperation {
    private int left;
    private int top;
    private int width;
    private int height;

    public void init(RAWImage image) throws Exception {
        PentaxMakerNote pefMakernote = (PentaxMakerNote)image.getRAWMetadata().getMakerNote();
        int[] tmp = pefMakernote.getImageCropCorner();
        this.left = tmp[0];
        this.top = tmp[1];
        tmp = pefMakernote.getImageCropSize();
        this.width = tmp[0];
        this.height = tmp[1];
    }

    protected Insets getCrop(RAWImage image) {
        return new Insets(this.top, this.left, image.getImage().getHeight() - this.top - this.height, image.getImage().getWidth() - this.left - this.width);
    }

    protected Dimension getSize(RAWImage image) {
        return new Dimension(this.width, this.height);
    }
}

