/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.pef;

import it.tidalwave.imageio.pef.PentaxMakerNote;
import it.tidalwave.imageio.rawprocessor.OperationSupport;
import it.tidalwave.imageio.rawprocessor.RAWImage;
import it.tidalwave.imageio.util.Logger;

public class PEFWhiteBalanceOperation
extends OperationSupport {
    private static final Logger logger = PEFWhiteBalanceOperation.getLogger(PEFWhiteBalanceOperation.class);

    public void process(RAWImage image) {
        logger.fine("process()", new Object[0]);
        PentaxMakerNote pefMakernote = (PentaxMakerNote)image.getRAWMetadata().getMakerNote();
        int[] coefficients = pefMakernote.getWhiteBalanceInfo();
        double scale = 1.220703125E-4;
        image.multiplyRedCoefficient(scale * (double)coefficients[0]);
        image.multiplyGreenCoefficient(scale * (double)coefficients[1]);
        image.multiplyBlueCoefficient(scale * (double)coefficients[3]);
    }
}

