/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.raf;

import it.tidalwave.imageio.raf.FujiRawData;
import it.tidalwave.imageio.raf.FujiTable1;
import it.tidalwave.imageio.raf.RAFMetadata;
import it.tidalwave.imageio.rawprocessor.RAWImage;
import it.tidalwave.imageio.rawprocessor.raw.RotateOperation;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Properties;

public class RAFRotateOperation
extends RotateOperation {
    private static final double SQRT05 = Math.sqrt(0.5);

    public void process(RAWImage image) throws Exception {
        int bandCount;
        BufferedImage oldBufferedImage = image.getImage();
        int originalWidth = oldBufferedImage.getWidth();
        int originalHeight = oldBufferedImage.getHeight();
        DataBufferUShort oldDataBuffer = (DataBufferUShort)oldBufferedImage.getData().getDataBuffer();
        short[] oldData = oldDataBuffer.getData();
        FujiRawData fujiRawData = ((RAFMetadata)image.getRAWMetadata()).getFujiRawData();
        FujiTable1 fujiTable1 = fujiRawData.getFujiTable1();
        boolean fujiLayout = fujiTable1.isFujiLayout();
        int offset = fujiTable1.getWidth() / (fujiLayout ? 1 : 2);
        int newWidth = (int)((double)offset / SQRT05);
        int newHeight = (int)((double)(originalHeight - offset) / SQRT05);
        boolean type = true;
        int[] bandOffsets = new int[]{0, 1, 2};
        int newPixelStride = bandCount = bandOffsets.length;
        int newScanlineStride = newPixelStride * newWidth;
        WritableRaster raster = Raster.createInterleavedRaster(1, newWidth, newHeight, newScanlineStride, newPixelStride, bandOffsets, null);
        BufferedImage newBufferedImage = new BufferedImage(oldBufferedImage.getColorModel(), raster, false, new Properties());
        DataBufferUShort newDataBuffer = (DataBufferUShort)raster.getDataBuffer();
        short[] newData = newDataBuffer.getData();
        int oldPixelStride = bandCount;
        int oldScanLineStride = originalWidth * bandCount;
        for (int y = 0; y < newHeight; ++y) {
            for (int x = 0; x < newWidth; ++x) {
                double x0f = (double)(y + x) * SQRT05;
                double y0f = (double)offset + (double)(y - x) * SQRT05;
                int x0 = (int)x0f;
                int y0 = (int)y0f;
                double fc = x0f - (double)x0;
                double fr = y0f - (double)y0;
                if (x0 > originalWidth - 2 || y0 > originalHeight - 2) continue;
                int scan = x0 * oldPixelStride + y0 * oldScanLineStride;
                int scan2 = scan + oldScanLineStride;
                for (int i = 0; i < bandCount; ++i) {
                    newData[y * newScanlineStride + x * newPixelStride + i] = (short)(((double)oldData[scan + i] * (1.0 - fc) + (double)oldData[scan + oldPixelStride + i] * fc) * (1.0 - fr) + ((double)oldData[scan2 + i] * (1.0 - fc) + (double)oldData[scan2 + oldPixelStride + i] * fc) * fr);
                }
            }
        }
        image.setImage(newBufferedImage);
    }
}

