/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.raf;

import it.tidalwave.imageio.raf.FujiRawData;
import it.tidalwave.imageio.raf.FujiTable1;
import it.tidalwave.imageio.raf.RAFMetadata;
import it.tidalwave.imageio.rawprocessor.OperationSupport;
import it.tidalwave.imageio.rawprocessor.RAWImage;
import it.tidalwave.imageio.util.Logger;

public class RAFWhiteBalanceOperation
extends OperationSupport {
    private static final Logger logger = RAFWhiteBalanceOperation.getLogger(RAFWhiteBalanceOperation.class);

    public void process(RAWImage image) {
        logger.fine("process()", new Object[0]);
        RAFMetadata rafMetadata = (RAFMetadata)image.getRAWMetadata();
        FujiRawData fujiRawData = rafMetadata.getFujiRawData();
        FujiTable1 fujiTable1 = fujiRawData.getFujiTable1();
        short[] coefficients = fujiTable1.getCoefficients();
        image.multiplyRedCoefficient((double)coefficients[1] / 256.0);
        image.multiplyGreenCoefficient((double)coefficients[0] / 256.0);
        image.multiplyBlueCoefficient((double)coefficients[3] / 256.0);
    }
}

