/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.raw;

import it.tidalwave.imageio.raw.TagRational;
import it.tidalwave.imageio.rawprocessor.ColorMatrix;
import it.tidalwave.imageio.rawprocessor.OperationSupport;
import it.tidalwave.imageio.rawprocessor.RAWImage;
import it.tidalwave.imageio.util.Logger;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;

public abstract class ColorConversionOperation
extends OperationSupport {
    private static final Logger logger = ColorConversionOperation.getLogger(ColorConversionOperation.class);

    public void process(RAWImage image) {
        ColorMatrix colorMatrix = this.getColorMatrix(image);
        if (colorMatrix != null) {
            ColorConversionOperation.applyMatrix(image.getImage().getRaster(), colorMatrix);
        }
    }

    protected ColorMatrix getColorMatrix(RAWImage image) {
        ColorMatrix colorMatrix = this.getColorMatrixXYZ(image);
        if (colorMatrix != null) {
            logger.info(">>>> colorMatrix in XYZ space: %s", colorMatrix);
            ColorMatrix colorMatrixRGB = colorMatrix.product(ColorMatrix.XYZ_TO_RGB);
            logger.info(">>>> colorMatrix in RGB space: %s", colorMatrixRGB);
            colorMatrixRGB.normalizeRows();
            logger.info(">>>> colorMatrix in RGB space, normalized: %s", colorMatrixRGB);
            colorMatrixRGB = colorMatrixRGB.inverse();
            logger.info(">>>> final colorMatrix: %s", colorMatrixRGB);
            return colorMatrixRGB;
        }
        return null;
    }

    protected ColorMatrix getColorMatrixXYZ(RAWImage image) {
        return null;
    }

    protected static ColorMatrix getMatrix(TagRational[] matrix) {
        double[] c = new double[matrix.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = matrix[i].doubleValue();
        }
        return new ColorMatrix(c);
    }

    protected static ColorMatrix getMatrix(int[] matrix, double scale) {
        double[] c = new double[matrix.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = scale * (double)matrix[i];
        }
        return new ColorMatrix(c);
    }

    private static void applyMatrix(WritableRaster raster, ColorMatrix colorMatrix1) {
        logger.fine("applyMatrix()", new Object[0]);
        logger.finer(">>>> raster: %s", raster);
        long time = System.currentTimeMillis();
        DataBufferUShort dataBuffer = (DataBufferUShort)raster.getDataBuffer();
        short[] data = dataBuffer.getData();
        int w = raster.getWidth();
        int h = raster.getHeight();
        while (raster.getParent() != null) {
            raster = (WritableRaster)raster.getParent();
        }
        int pixelStride = raster.getNumBands();
        int scanStride = raster.getWidth() * pixelStride;
        logger.finer(">>>> pixelStride: %d, scanStride: %d", pixelStride, scanStride);
        logger.finer(">>>> offset: %d", dataBuffer.getOffset());
        w = raster.getWidth();
        h = raster.getHeight();
        for (int y = 0; y < h; ++y) {
            int scan = y * scanStride + dataBuffer.getOffset();
            for (int x = 0; x < w; ++x) {
                colorMatrix1.process(data, scan);
                scan += pixelStride;
            }
            Thread.yield();
        }
        logger.finest(">>>> applyMatrix() completed ok in %d msec.", System.currentTimeMillis() - time);
    }
}

