/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.raw;

import it.tidalwave.imageio.raw.TagRational;
import it.tidalwave.imageio.rawprocessor.OperationSupport;
import it.tidalwave.imageio.rawprocessor.RAWImage;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.TIFFMetadataSupport;
import it.tidalwave.imageio.util.Logger;

public class CurveOperation
extends OperationSupport {
    private static final Logger logger = CurveOperation.getLogger(CurveOperation.class);
    protected static final double MAX_LEVEL = 65535.0;

    public void process(RAWImage image) {
        logger.fine("process()", new Object[0]);
        double[] normalizationFactor = this.getNormalizationFactor(image);
        image.multiplyRedCoefficient(normalizationFactor[0]);
        image.multiplyGreenCoefficient(normalizationFactor[1]);
        image.multiplyBlueCoefficient(normalizationFactor[2]);
    }

    protected double[] getNormalizationFactor(RAWImage image) {
        logger.fine("getNormalizationFactor()", new Object[0]);
        int[] blackLevel = this.getBlackLevel(image);
        double whiteLevel = this.getWhiteLevel(image);
        double[] normalizationFactor = new double[3];
        logger.finer(">>>> blackLevel: %d %d %d", blackLevel[0], blackLevel[1], blackLevel[2]);
        logger.finer(">>>> whiteLevel: %f", whiteLevel);
        for (int i = 0; i < normalizationFactor.length; ++i) {
            normalizationFactor[i] = 65535.0 / (whiteLevel - (double)blackLevel[i]);
        }
        image.setBlackLevel((blackLevel[0] + blackLevel[1] + blackLevel[2]) / 3);
        logger.finer(">>>> normalizationFactor: %f %f %f", normalizationFactor[0], normalizationFactor[1], normalizationFactor[2]);
        return normalizationFactor;
    }

    protected int[] getBlackLevel(RAWImage image) {
        return new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    }

    protected double getWhiteLevel(RAWImage image) {
        logger.fine("getWhiteLevel()", new Object[0]);
        TIFFMetadataSupport metadata = (TIFFMetadataSupport)image.getRAWMetadata();
        IFD rasterIFD = metadata.getRasterIFD();
        int bitsPerSample = rasterIFD.getBitsPerSample()[0];
        double whiteLevel = (1 << bitsPerSample) - 1;
        logger.finer(">>>> whiteLevel from bitsPerSample: %f", whiteLevel);
        return whiteLevel;
    }

    protected static double getMeanValue(TagRational[] black) {
        double v = 0.0;
        for (int i = 0; i < black.length; ++i) {
            v += black[i].doubleValue();
        }
        return v / (double)black.length;
    }
}

