/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.raw;

import it.tidalwave.imageio.rawprocessor.Curve;
import it.tidalwave.imageio.rawprocessor.OperationSupport;
import it.tidalwave.imageio.rawprocessor.RAWImage;
import it.tidalwave.imageio.rawprocessor.demosaic.DemosaicFilterProcessor;
import it.tidalwave.imageio.util.Logger;

public class DemosaicOperation
extends OperationSupport {
    private static final Logger logger = DemosaicOperation.getLogger(DemosaicOperation.class);
    protected String algorithm;
    protected DemosaicFilterProcessor processor;
    private int[] cfaPattern;
    private String cfaPatternAsString;

    public void process(RAWImage image) throws Exception {
        logger.fine("process()", new Object[0]);
        this.cfaPattern = image.getCFAPattern();
        String cfaPatternAsString = image.getCFAPatternAsString();
        this.algorithm = this.chooseDemosaicAlgorithm(cfaPatternAsString);
        double redCoeff = image.getRedCoefficient();
        double greenCoeff = image.getGreenCoefficient();
        double blueCoeff = image.getBlueCoefficient();
        double blackLevel = image.getBlackLevel();
        Curve curve = image.getCurve();
        this.processor = new DemosaicFilterProcessor(cfaPatternAsString, this.algorithm, redCoeff, greenCoeff, blueCoeff, blackLevel, curve);
        logger.finer("Bayer pattern: %s", cfaPatternAsString);
        this.processor.process(image.getImage());
    }

    protected String chooseDemosaicAlgorithm(String cfaPatternAsString) {
        if (!cfaPatternAsString.equals("GRBG")) {
            return "Bilinear";
        }
        return "PixelGrouping";
    }
}

