/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.raw;

import it.tidalwave.imageio.rawprocessor.OperationSupport;
import it.tidalwave.imageio.rawprocessor.RAWImage;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.IFDGenerated;
import it.tidalwave.imageio.tiff.TIFFMetadataSupport;
import it.tidalwave.imageio.util.Logger;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Properties;

public class RotateOperation
extends OperationSupport {
    private static final Logger logger = RotateOperation.getLogger(RotateOperation.class);

    public void process(RAWImage image) throws Exception {
        logger.fine("process()", new Object[0]);
        int rotation = this.getCameraOrientation(image);
        if (rotation != 0) {
            image.setImage(RotateOperation.rotateQuadrant(image.getImage(), rotation));
            image.setRotation(rotation);
        }
    }

    protected int getCameraOrientation(RAWImage image) {
        TIFFMetadataSupport metadata = (TIFFMetadataSupport)image.getRAWMetadata();
        IFD primaryIFD = metadata.getPrimaryIFD();
        IFD exifIFD = metadata.getExifIFD();
        int orientation = 0;
        IFDGenerated.Orientation tiffOrientation = null;
        if (primaryIFD.isOrientationAvailable()) {
            tiffOrientation = primaryIFD.getOrientation();
        } else if (exifIFD.isOrientationAvailable()) {
            tiffOrientation = exifIFD.getOrientation();
        }
        if (tiffOrientation == IFDGenerated.Orientation.LEFT_BOTTOM) {
            orientation = -90;
        }
        if (tiffOrientation == IFDGenerated.Orientation.RIGHT_TOP) {
            orientation = 90;
        }
        logger.finer(">>>> camera orientation: %s, degrees: %d", tiffOrientation, orientation);
        return orientation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static BufferedImage rotateQuadrant(BufferedImage image, int degrees) {
        logger.finer("rotateQuadrant(%d)", degrees);
        RotateOperation.logImage(logger, ">>>> image: ", image);
        SampleModel sampleModel = image.getSampleModel();
        if (degrees < 0) {
            degrees += 360;
        }
        if (degrees == 90 || degrees == 270) {
            sampleModel = sampleModel.createCompatibleSampleModel(image.getHeight(), image.getWidth());
        }
        WritableRaster newRaster = Raster.createWritableRaster(sampleModel, null);
        ColorModel colorModel = image.getColorModel();
        BufferedImage result = new BufferedImage(colorModel, newRaster, false, RotateOperation.getProperties(image));
        Graphics2D g2d = (Graphics2D)result.getGraphics();
        try {
            double radians = Math.toRadians(degrees);
            g2d.transform(AffineTransform.getRotateInstance(radians));
            int x = 0;
            int y = 0;
            switch (degrees) {
                case 90: {
                    y = -image.getHeight();
                    break;
                }
                case 180: {
                    x = -image.getWidth();
                    y = -image.getHeight();
                    break;
                }
                case 270: {
                    x = -image.getWidth();
                }
            }
            g2d.drawImage((Image)image, x, y, null);
        }
        finally {
            g2d.dispose();
        }
        RotateOperation.logImage(logger, ">>>> rotateQuadrant() returning ", result);
        return result;
    }

    private static Properties getProperties(BufferedImage image) {
        Properties properties = new Properties();
        String[] propertyNames = image.getPropertyNames();
        if (propertyNames != null) {
            for (int i = 0; i < propertyNames.length; ++i) {
                String propertyName = propertyNames[i];
                Object propertyValue = image.getProperty(propertyName);
                properties.setProperty(propertyName, propertyValue.toString());
            }
        }
        return properties;
    }
}

