/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.raw;

import it.tidalwave.imageio.raw.TagRational;
import it.tidalwave.imageio.rawprocessor.OperationSupport;
import it.tidalwave.imageio.rawprocessor.RAWImage;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.TIFFMetadataSupport;
import it.tidalwave.imageio.util.Logger;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public abstract class SizeOperation
extends OperationSupport {
    private static final Logger logger = SizeOperation.getLogger(SizeOperation.class);
    protected static final TagRational ONE = new TagRational(1, 1);
    protected static final TagRational[] SCALE_UNCHANGED = new TagRational[]{ONE, ONE};
    private final Properties properties = new Properties();

    public SizeOperation() {
        try {
            String fileName = "/" + this.getClass().getName().replace('.', '/') + ".properties";
            InputStream is = this.getClass().getResourceAsStream(fileName);
            if (is != null) {
                this.properties.load(is);
                is.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void process(@Nonnull RAWImage image) throws Exception {
        Dimension size;
        logger.fine("process()", new Object[0]);
        Insets crop = this.getCrop(image);
        if (crop != null) {
            logger.finer(">>>> crop: %s", crop);
            image.setImage(this.crop(image.getImage(), crop));
        }
        if ((size = this.getSize(image)) != null) {
            logger.finer(">>>> size: %s", size);
            image.setImage(this.resample(image.getImage(), size));
        }
    }

    @Nonnull
    protected Insets getCrop(@Nonnull RAWImage image) {
        logger.fine("getCrop()", new Object[0]);
        TIFFMetadataSupport metadata = (TIFFMetadataSupport)image.getRAWMetadata();
        IFD primaryIFD = metadata.getPrimaryIFD();
        Insets crop = this.getStandardCrop(primaryIFD.getModel());
        if (crop == null) {
            crop = new Insets(0, 0, 0, 0);
        }
        return crop;
    }

    @Nonnull
    protected Dimension getSize(@Nonnull RAWImage image) {
        logger.fine("getSize()", new Object[0]);
        TIFFMetadataSupport metadata = (TIFFMetadataSupport)image.getRAWMetadata();
        IFD primaryIFD = metadata.getPrimaryIFD();
        return this.getStandardSize(primaryIFD.getModel());
    }

    @Nonnull
    protected BufferedImage resample(@Nonnull BufferedImage image, @Nonnull Dimension dimension) {
        logger.warning("resample(" + dimension + ") - NOT IMPLEMENTED", new Object[0]);
        SizeOperation.logImage(logger, ">>>> image: ", image);
        SizeOperation.logImage(logger, ">>>> resample returning: ", image);
        return image;
    }

    @Nonnull
    protected BufferedImage crop(@Nonnull BufferedImage image, @Nonnull Insets crop) {
        logger.finer("crop(%s)", crop);
        SizeOperation.logImage(logger, ">>>> image: ", image);
        image = image.getSubimage(crop.left, crop.top, image.getWidth() - crop.left - crop.right, image.getHeight() - crop.top - crop.bottom);
        SizeOperation.logImage(logger, ">>>> crop returning: ", image);
        return image;
    }

    @Nonnull
    protected static Insets rotate(@Nonnull Insets crop, @Nonnegative int rotation) {
        logger.finer(String.format("rotate(%s, %d)", crop, rotation), new Object[0]);
        Insets result = new Insets(0, 0, 0, 0);
        switch (rotation) {
            case 0: {
                result.left = crop.left;
                result.top = crop.top;
                result.right = crop.right;
                result.bottom = crop.bottom;
                break;
            }
            case 90: {
                result.left = crop.top;
                result.top = crop.right;
                result.right = crop.bottom;
                result.bottom = crop.left;
                break;
            }
            case 180: {
                result.left = crop.right;
                result.top = crop.bottom;
                result.right = crop.left;
                result.bottom = crop.top;
                break;
            }
            case 270: {
                result.left = crop.bottom;
                result.top = crop.left;
                result.right = crop.top;
                result.bottom = crop.right;
                break;
            }
            default: {
                throw new IllegalArgumentException("rotation=" + rotation);
            }
        }
        logger.finest(">>>> returning: %s", result);
        return result;
    }

    @Nonnull
    protected static Rectangle rotate(@Nonnull Rectangle rectangle, @Nonnull Dimension size, @Nonnegative int rotation) {
        logger.finest("rotate(%s, %s, %d)", rectangle, size, rotation);
        Rectangle result = new Rectangle(0, 0, 0, 0);
        switch (rotation) {
            case 0: {
                result.x = rectangle.x;
                result.y = rectangle.y;
                result.width = rectangle.width;
                result.height = rectangle.height;
                break;
            }
            case 90: {
                result.x = rectangle.y;
                result.y = size.width - rectangle.x - rectangle.width;
                result.width = rectangle.height;
                result.height = rectangle.width;
                break;
            }
            case 180: {
                result.x = size.width - rectangle.x - rectangle.width;
                result.y = size.height - rectangle.y - rectangle.height;
                result.width = rectangle.width;
                result.height = rectangle.height;
                break;
            }
            case 270: {
                result.x = size.height - rectangle.y - rectangle.height;
                result.y = rectangle.x;
                result.width = rectangle.height;
                result.height = rectangle.width;
                break;
            }
            default: {
                throw new IllegalArgumentException("rotation=" + rotation);
            }
        }
        logger.finest(">>>> returning: %s", result);
        return result;
    }

    @Nonnull
    public Dimension getStandardSize(@Nonnull String model) {
        model = model.trim();
        logger.fine("getStandardSize(%s)", model);
        String string = this.properties.getProperty(model);
        Dimension size = null;
        if (string != null) {
            StringTokenizer st = new StringTokenizer(string, " \t");
            int width = Integer.parseInt(st.nextToken());
            int height = Integer.parseInt(st.nextToken());
            size = new Dimension(width, height);
        }
        logger.finer(">>>> size: %s", size);
        return size;
    }

    @Nonnull
    public Insets getStandardCrop(@Nonnull String model) {
        model = model.trim();
        logger.fine("getStandardCrop(%s)", model);
        String string = this.properties.getProperty(model);
        Insets cropInsets = null;
        if (string != null) {
            StringTokenizer st = new StringTokenizer(string, " \t");
            st.nextToken();
            st.nextToken();
            int l = Integer.parseInt(st.nextToken());
            int r = Integer.parseInt(st.nextToken());
            int t = Integer.parseInt(st.nextToken());
            int b = Integer.parseInt(st.nextToken());
            cropInsets = new Insets(t, l, b, r);
        }
        logger.finer(">>>> cropInsets: %s", cropInsets);
        return cropInsets;
    }
}

