/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.tiff;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.raw.Directory;
import it.tidalwave.imageio.raw.TagRegistry;
import it.tidalwave.imageio.tiff.TIFFTag;
import it.tidalwave.imageio.util.Logger;
import java.io.IOException;
import javax.annotation.Nonnull;

public class IFDSupport
extends Directory {
    private static final String CLASS = IFDSupport.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private static final long serialVersionUID = -8252917582886315978L;

    public IFDSupport() {
    }

    protected IFDSupport(@Nonnull TagRegistry tagRegistry) {
        super(tagRegistry);
    }

    public long load(@Nonnull RAWImageInputStream iis, long offset) throws IOException {
        int entryCount;
        logger.finer(">>>> Reading IFD at offset: %d + %d", offset, iis.getBaseOffset());
        try {
            iis.seek(offset);
            this.start = iis.getStreamPosition() + iis.getBaseOffset();
            entryCount = iis.readShort();
        }
        catch (Exception e) {
            logger.warning("Ignoring invalid ifdOffset: %d", offset);
            return 0L;
        }
        logger.finest(">>>> entryCount: %d", entryCount);
        for (int i = 0; i < entryCount; ++i) {
            int ifdTag = iis.readUnsignedShort();
            TIFFTag tag = new TIFFTag(this.tagRegistry, ifdTag);
            tag.read(iis);
            this.addTag(tag);
        }
        offset = iis.readUnsignedInt();
        this.end = iis.getStreamPosition() + iis.getBaseOffset() - 1L;
        logger.finest(">>>> next ifdOffset: %d", offset);
        logger.finest(">>>> loaded: %s", this);
        return offset;
    }
}

