/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.tiff;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.raw.Directory;
import it.tidalwave.imageio.raw.HeaderProcessor;
import it.tidalwave.imageio.raw.RAWMetadataSupport;
import it.tidalwave.imageio.raw.TagRational;
import it.tidalwave.imageio.raw.TagRegistry;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.TIFFTag;
import it.tidalwave.imageio.tiff.ThumbnailHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class TIFFMetadataSupport
extends RAWMetadataSupport {
    private static final String[] ORIENTATION_NAMES = new String[]{null, "Normal", "FlipH", "Rotate180", "FlipV", "FlipHRotate90", "Rotate270", "FlipVRotate90", "Rotate90"};
    private static final String[] COLOR_SPACE_NAMES = new String[]{"GRAY", "GRAY", "RGB", "RGB", "GRAY", null, "YCbCr", "Lab", "Lab"};
    private static final String[] TYPE_NAMES = new String[]{null, "Byte", "Ascii", "Short", "Long", "Rational", "SByte", "Undefined", "SShort", "SLong", "SRational", "Float", "Double", "IFDPointer"};
    @Nonnull
    private IFD primaryIFD;
    @CheckForNull
    private IFD exifIFD;
    @CheckForNull
    protected IFD rasterIFD;
    protected final List<ThumbnailHelper> thumbnailHelperList = new ArrayList<ThumbnailHelper>();

    public TIFFMetadataSupport(@Nonnull Directory primaryDirectory, @Nonnull RAWImageInputStream iis, @Nonnull HeaderProcessor headerProcessor) {
        super(primaryDirectory, "it_tidalwave_imageio_tiff_image_1.0", headerProcessor);
        if (primaryDirectory != null) {
            this.primaryIFD = (IFD)primaryDirectory;
            this.exifIFD = (IFD)primaryDirectory.getNamedDirectory("EXIF");
            if (this.exifIFD == null) {
                for (Directory directory : primaryDirectory.getSubDirectories()) {
                    this.exifIFD = (IFD)directory.getNamedDirectory("EXIF");
                    if (this.exifIFD == null) continue;
                    break;
                }
            }
            ArrayList<IFD> ifdList = new ArrayList<IFD>();
            for (IFD ifd = this.primaryIFD; ifd != null; ifd = (IFD)ifd.getNextDirectory()) {
                ifdList.add(ifd);
            }
            for (Directory directory : this.primaryIFD.getSubDirectories()) {
                ifdList.add((IFD)directory);
            }
            for (IFD ifd : ifdList) {
                if (this.isRasterIFD(ifd)) {
                    this.rasterIFD = ifd;
                }
                if (!this.isThumbnailIFD(ifd)) continue;
                this.thumbnailHelperList.add(new ThumbnailHelper(iis, ifd));
            }
        }
        this.postInit(iis);
    }

    @Nonnegative
    public int getWidth() {
        return this.rasterIFD.getImageWidth();
    }

    @Nonnegative
    public int getHeight() {
        return this.rasterIFD.getImageLength();
    }

    @Nonnegative
    public int getThumbnailWidth(@Nonnegative int thumbnailIndex) {
        return this.thumbnailHelperList.get(thumbnailIndex).getWidth();
    }

    @Nonnegative
    public int getThumbnailHeight(@Nonnegative int thumbnailIndex) {
        return this.thumbnailHelperList.get(thumbnailIndex).getHeight();
    }

    @Nonnull
    public ThumbnailHelper[] getThumbnailHelper() {
        return this.thumbnailHelperList.toArray(new ThumbnailHelper[0]);
    }

    @Nonnull
    public IFD getPrimaryIFD() {
        return this.primaryIFD;
    }

    @Nonnull
    public IFD getRasterIFD() {
        return this.rasterIFD;
    }

    @CheckForNull
    public IFD getExifIFD() {
        return this.exifIFD;
    }

    @CheckForNull
    public Directory getMakerNote() {
        IFD exifIFD = this.getExifIFD();
        return exifIFD == null ? null : exifIFD.getNamedDirectory("MakerNote");
    }

    @Nonnull
    public IIOMetadataNode getStandardDimensionNode() {
        int o;
        IIOMetadataNode dimensionNode = new IIOMetadataNode("Dimension");
        IFD resolutionIFD = this.getPrimaryIFD();
        IFD orientationIFD = this.getPrimaryIFD();
        if (resolutionIFD.isXResolutionAvailable() && resolutionIFD.isYResolutionAvailable()) {
            TagRational xres = resolutionIFD.getXResolution();
            TagRational yres = resolutionIFD.getYResolution();
            IIOMetadataNode node = new IIOMetadataNode("PixelAspectRatio");
            float ratio = xres.floatValue() / yres.floatValue();
            node.setAttribute("value", Float.toString(ratio));
            dimensionNode.appendChild(node);
            boolean gotPixelSize = false;
            if (resolutionIFD.isResolutionUnitAvailable()) {
                int resolutionUnit = resolutionIFD.getResolutionUnit().intValue();
                if (resolutionUnit == 3) {
                    gotPixelSize = true;
                } else if (resolutionUnit == 2) {
                    if (xres != null) {
                        xres.multiply(254, 100);
                    }
                    if (yres != null) {
                        yres.multiply(254, 100);
                    }
                    gotPixelSize = true;
                }
            }
            if (gotPixelSize) {
                if (xres != null) {
                    float horizontalPixelSize = 10.0f / xres.floatValue();
                    TIFFMetadataSupport.addNameValueNode(dimensionNode, "HorizontalPixelSize", Float.toString(horizontalPixelSize));
                }
                if (yres != null) {
                    float verticalPixelSize = 10.0f / yres.floatValue();
                    TIFFMetadataSupport.addNameValueNode(dimensionNode, "VerticalPixelSize", Float.toString(verticalPixelSize));
                }
            }
        }
        if (orientationIFD.isOrientationAvailable() && (o = orientationIFD.getOrientation().intValue()) >= 0 && o < ORIENTATION_NAMES.length) {
            TIFFMetadataSupport.addNameValueNode(dimensionNode, "ImageOrientation", ORIENTATION_NAMES[o]);
        }
        TIFFMetadataSupport.addNameValueNode(dimensionNode, "HorizontalScreenSize", Integer.toString(this.getWidth()));
        TIFFMetadataSupport.addNameValueNode(dimensionNode, "VerticalScreenSize", Integer.toString(this.getHeight()));
        return dimensionNode;
    }

    @Nonnull
    public IIOMetadataNode getStandardChromaNode() {
        IIOMetadataNode node;
        IIOMetadataNode chromaNode = new IIOMetadataNode("Chroma");
        if (this.primaryIFD.isPhotometricInterpretationAvailable()) {
            int photometricInterpretation = this.primaryIFD.getPhotometricInterpretation().intValue();
            if (photometricInterpretation > 0 && photometricInterpretation < COLOR_SPACE_NAMES.length) {
                node = new IIOMetadataNode("ColorSpaceType");
                node.setAttribute("name", COLOR_SPACE_NAMES[photometricInterpretation]);
                chromaNode.appendChild(node);
            }
            node = new IIOMetadataNode("BlackIsZero");
            node.setAttribute("value", photometricInterpretation != 0 ? "TRUE" : "FALSE");
            chromaNode.appendChild(node);
        }
        if (this.primaryIFD.isBitsPerSampleAvailable()) {
            int numChannels = this.primaryIFD.getBitsPerSample().length;
            node = new IIOMetadataNode("NumChannels");
            node.setAttribute("value", Integer.toString(numChannels));
            chromaNode.appendChild(node);
        }
        return chromaNode;
    }

    @Nonnull
    public IIOMetadataNode getStandardDocumentNode() {
        IIOMetadataNode documentNode = new IIOMetadataNode("Document");
        if (this.primaryIFD.isDateTimeAvailable()) {
            String s = this.primaryIFD.getDateTime();
            String[] st = s.split("[:. ]");
            IIOMetadataNode node = new IIOMetadataNode("ImageCreationTime");
            node.setAttribute("year", st[0]);
            node.setAttribute("month", st[1]);
            node.setAttribute("day", st[2]);
            node.setAttribute("hour", st[3]);
            node.setAttribute("minute", st[4]);
            if (st.length > 5) {
                node.setAttribute("second", st[5]);
            }
            documentNode.appendChild(node);
        }
        return documentNode;
    }

    @Nonnull
    public Node getNativeNode(@Nonnull TIFFTag field, @Nonnull TagRegistry registry) {
        IIOMetadataNode node = new IIOMetadataNode("TIFFField");
        node.setAttribute("number", Integer.toString(field.getCode()));
        String name = registry.getTagName(field.getCode());
        if (name != null) {
            node.setAttribute("name", name);
        }
        int count = field.getValuesCount();
        int type = field.getType();
        IIOMetadataNode child = new IIOMetadataNode("TIFF" + TYPE_NAMES[type] + "s");
        if (type == 7) {
            child = new IIOMetadataNode("TIFFUndefined");
            byte[] data = field.getByteValues();
            StringBuilder sb = new StringBuilder(count * 4);
            for (int j = 0; j < count; ++j) {
                sb.append(Integer.toString(data[j] & 0xFF));
                if (j >= count - 1) continue;
                sb.append(",");
            }
            child.setAttribute("value", sb.toString());
        } else {
            for (int i = 0; i < count; ++i) {
                IIOMetadataNode cchild = new IIOMetadataNode("TIFF" + TYPE_NAMES[type]);
                switch (type) {
                    case 1: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 8: 
                    case 9: {
                        cchild.setAttribute("value", Integer.toString(field.getIntValues()[i]));
                        break;
                    }
                    case 5: 
                    case 10: 
                    case 11: 
                    case 12: {
                        cchild.setAttribute("value", field.getRationalValues()[i].toString());
                        break;
                    }
                    case 2: {
                        StringBuilder buffer = new StringBuilder();
                        String value = field.getASCIIValue();
                        for (int j = 0; j < value.length(); ++j) {
                            char c = value.charAt(j);
                            if (c >= ' ' && c <= '\u007f') {
                                buffer.append(c);
                                continue;
                            }
                            buffer.append("\\u0x" + Integer.toHexString(c));
                        }
                        cchild.setAttribute("value", buffer.toString());
                        i = count;
                    }
                }
                child.appendChild(cchild);
            }
        }
        node.appendChild(child);
        return node;
    }

    protected void postInit(@Nonnull RAWImageInputStream iis) {
    }

    protected boolean isRasterIFD(IFD ifd) {
        return false;
    }

    protected boolean isThumbnailIFD(IFD ifd) {
        return false;
    }

    @Nonnull
    protected Node getNativeTree(@Nonnull String name) {
        IIOMetadataNode root = new IIOMetadataNode(name);
        if (this.primaryIFD != null) {
            this.appendIFDAsTree(root, this.primaryIFD, "IFD", null, 0);
        }
        return root;
    }

    private static void addNameValueNode(@Nonnull IIOMetadataNode parent, @Nonnull String name, @Nonnull String value) {
        IIOMetadataNode node = new IIOMetadataNode(name);
        node.setAttribute("value", value);
        parent.appendChild(node);
    }

    private void appendIFDAsTree(IIOMetadataNode parentNode, Directory directory, String name, String parentName, int parentTagNumber) {
        int ifdCounter = 0;
        Directory currentDirectory = directory;
        while (currentDirectory != null) {
            IIOMetadataNode directoryNode = new IIOMetadataNode("TIFFIFD");
            parentNode.appendChild(directoryNode);
            String currentName = name;
            if (currentName.equals("IFD")) {
                currentName = currentName + ifdCounter;
            }
            directoryNode.setAttribute("name", currentName);
            directoryNode.setAttribute("start", Long.toString(currentDirectory.getStart()));
            directoryNode.setAttribute("end", Long.toString(currentDirectory.getEnd()));
            if (parentName != null) {
                directoryNode.setAttribute("parentName", parentName);
            }
            if (parentTagNumber != 0) {
                directoryNode.setAttribute("parentNumber", Integer.toString(parentTagNumber));
            }
            for (TIFFTag tIFFTag : currentDirectory.getTags()) {
                int tagNumber = tIFFTag.getCode();
                Integer t = new Integer(tagNumber);
                Node node = this.getNativeNode(tIFFTag, currentDirectory.getRegistry());
                if (node == null) continue;
                directoryNode.appendChild(node);
            }
            int n = 0;
            for (Directory subIFD : currentDirectory.getSubDirectories()) {
                this.appendIFDAsTree(directoryNode, (IFD)subIFD, "SubIFD" + n++, currentName, 0);
            }
            String[] stringArray = currentDirectory.getSubDirectoryNames();
            for (int j = 0; j < stringArray.length; ++j) {
                int tagNumber = 0;
                Directory subIFD = currentDirectory.getNamedDirectory(stringArray[j]);
                this.appendIFDAsTree(directoryNode, subIFD, stringArray[j], currentName, tagNumber);
            }
            currentDirectory = currentDirectory.getNextDirectory();
            ++ifdCounter;
        }
    }

    @Nonnull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getName() + "[");
        buffer.append("\n****primaryDirectory: " + this.primaryIFD);
        buffer.append("\n****exifIFD: " + this.getExifIFD());
        buffer.append("\n****makerNoteDirectory: " + this.getMakerNote());
        return buffer.toString();
    }
}

