/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.tiff;

import it.tidalwave.imageio.raw.AbstractTag;
import it.tidalwave.imageio.raw.TagRational;
import it.tidalwave.imageio.raw.TagRegistry;
import it.tidalwave.imageio.util.Logger;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.imageio.stream.ImageInputStream;

public class TIFFTag
extends AbstractTag {
    private static final String CLASS = TIFFTag.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private static final long serialVersionUID = 6025163135754787912L;
    public static final short TYPE_BYTE = 1;
    public static final short TYPE_ASCII = 2;
    public static final short TYPE_SHORT = 3;
    public static final short TYPE_LONG = 4;
    public static final short TYPE_RATIONAL = 5;
    public static final short TYPE_SBYTE = 6;
    public static final short TYPE_UNDEFINED = 7;
    public static final short TYPE_SSHORT = 8;
    public static final short TYPE_SLONG = 9;
    public static final short TYPE_SRATIONAL = 10;
    public static final short TYPE_FLOAT = 11;
    public static final short TYPE_DOUBLE = 12;
    public static final short TYPE_ORF_13 = 13;
    private static final String[] typeToString = new String[14];
    private long valueOffset;

    public TIFFTag(TagRegistry registry, int code) {
        super(registry, code);
    }

    public int getValueOffset() {
        return (int)this.valueOffset;
    }

    @CheckForNull
    public Object getValue() {
        switch (this.type) {
            case 1: 
            case 6: {
                if (this.intValue.length == 1) {
                    return new Byte((byte)this.intValue[0]);
                }
                byte[] bytes = new byte[this.intValue.length];
                for (int i = 0; i < bytes.length; ++i) {
                    bytes[i] = (byte)this.intValue[i];
                }
                return bytes;
            }
            case 3: 
            case 8: {
                if (this.intValue.length == 1) {
                    return new Short((short)this.intValue[0]);
                }
                short[] shorts = new short[this.intValue.length];
                for (int i = 0; i < shorts.length; ++i) {
                    shorts[i] = (short)this.intValue[i];
                }
                return shorts;
            }
            case 0: 
            case 4: 
            case 9: 
            case 13: {
                return this.intValue.length == 1 ? new Integer(this.intValue[0]) : (Object)this.intValue;
            }
            case 2: {
                return this.asciiValue;
            }
            case 5: 
            case 10: {
                return this.rationalValue.length == 1 ? this.rationalValue[0] : this.rationalValue;
            }
            case 7: {
                return this.undefinedValue;
            }
        }
        throw new RuntimeException("Unsupported type:" + this.type);
    }

    public void read(ImageInputStream iis) throws IOException {
        this.type = iis.readUnsignedShort();
        this.valuesCount = iis.readInt();
        if (this.code == 37500) {
            this.type = 4;
            this.valuesCount = 1;
        }
        switch (this.type) {
            case 1: 
            case 6: {
                this.intValue = this.readByteValues(iis, this.valuesCount);
                if (this.type != 1) break;
                int i = 0;
                while (i < this.intValue.length) {
                    int n = i++;
                    this.intValue[n] = this.intValue[n] & 0xFF;
                }
                break;
            }
            case 3: 
            case 8: {
                int i;
                this.intValue = this.readShortValues(iis, this.valuesCount);
                if (this.type == 3) {
                    i = 0;
                    while (i < this.intValue.length) {
                        int n = i++;
                        this.intValue[n] = this.intValue[n] & 0xFFFF;
                    }
                }
                this.rationalValue = new TagRational[this.intValue.length];
                for (i = 0; i < this.intValue.length; ++i) {
                    this.rationalValue[i] = new TagRational(this.intValue[i], 1);
                }
                break;
            }
            case 0: 
            case 4: 
            case 9: 
            case 13: {
                this.intValue = this.readIntValues(iis, this.valuesCount);
                break;
            }
            case 2: {
                this.asciiValue = this.readASCIIValue(iis, this.valuesCount);
                break;
            }
            case 5: {
                this.rationalValue = this.readRationalValues(iis, this.valuesCount);
                break;
            }
            case 7: {
                this.undefinedValue = this.readUndefinedValues(iis, this.valuesCount);
                break;
            }
            case 10: {
                this.rationalValue = this.readRationalValues(iis, this.valuesCount);
                break;
            }
            case 11: {
                logger.warning("WARNING: TIFF type not implemented [FLOAT]: " + this.type, new Object[0]);
                iis.readUnsignedInt();
                break;
            }
            case 12: {
                logger.warning("WARNING: TIFF type not implemented [DOUBLE]: " + this.type, new Object[0]);
                iis.readUnsignedInt();
                break;
            }
            default: {
                logger.warning("WARNING: TIFF type unknown: " + this.type, new Object[0]);
                iis.readUnsignedInt();
            }
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof TIFFTag)) {
            return false;
        }
        TIFFTag t = (TIFFTag)o;
        if (this.code != t.code || this.type != t.type || this.valuesCount != t.valuesCount) {
            return false;
        }
        if (this.intValue != null) {
            for (int i = 0; i < this.intValue.length; ++i) {
                if (this.intValue[i] == t.intValue[i]) continue;
                return false;
            }
        } else if (this.rationalValue != null) {
            for (int i = 0; i < this.rationalValue.length; ++i) {
                if (this.rationalValue[i].equals(t.rationalValue[i])) continue;
                return false;
            }
        } else {
            if (this.asciiValue != null) {
                return this.asciiValue.equals(t.asciiValue);
            }
            if (this.undefinedValue != null) {
                for (int i = 0; i < this.undefinedValue.length; ++i) {
                    if (this.undefinedValue[i] == t.undefinedValue[i]) continue;
                    return false;
                }
            } else {
                throw new RuntimeException();
            }
        }
        return true;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (int)(this.valueOffset ^ this.valueOffset >>> 32);
        hash = 97 * hash + this.code;
        hash = 97 * hash + this.type;
        hash = 97 * hash + this.valuesCount;
        if (this.intValue != null) {
            hash = 97 * hash + Arrays.hashCode(this.intValue);
        } else if (this.rationalValue != null) {
            hash = 97 * hash + Arrays.hashCode(this.rationalValue);
        } else if (this.asciiValue != null) {
            hash = 97 * hash + this.asciiValue.hashCode();
        } else if (this.undefinedValue != null) {
            hash = 97 * hash + Arrays.hashCode(this.undefinedValue);
        }
        return hash;
    }

    @Nonnull
    public String toString() {
        String name = this.registry.getTagName(this.code);
        if (name == null) {
            name = "#" + this.code;
        }
        StringBuilder buffer = new StringBuilder(name);
        buffer.append(" type: ");
        buffer.append(this.type < typeToString.length ? typeToString[this.type] : "unknown type " + this.type);
        if (this.valuesCount != 1) {
            buffer.append("[" + this.valuesCount + "]");
        }
        buffer.append(" value: ");
        this.appendValues(buffer);
        return buffer.toString();
    }

    private String readASCIIValue(ImageInputStream iis, int valueCount) throws IOException {
        char ch;
        StringBuffer buffer = new StringBuffer();
        boolean needReset = false;
        if (valueCount > 4) {
            needReset = true;
            long valueOffset = iis.readUnsignedInt();
            iis.mark();
            iis.seek(valueOffset);
        }
        int i = valueCount;
        while (i-- > 0 && ((ch = (char)iis.readByte()) != '\u0000' || i != 0)) {
            buffer.append(ch);
        }
        if (needReset) {
            iis.reset();
        } else {
            iis.skipBytes(4 - this.valuesCount);
        }
        return buffer.toString();
    }

    private TagRational[] readRationalValues(ImageInputStream iis, int valuesCount) throws IOException {
        long valueOffset = iis.readUnsignedInt();
        TagRational[] buffer = new TagRational[valuesCount];
        iis.mark();
        iis.seek(valueOffset);
        for (int i = 0; i < valuesCount; ++i) {
            int n = iis.readInt();
            int d = iis.readInt();
            buffer[i] = new TagRational(n, d);
        }
        iis.reset();
        return buffer;
    }

    private int[] readIntValues(ImageInputStream iis, int valuesCount) throws IOException {
        long valueOffset = iis.readUnsignedInt();
        if (valuesCount == 1) {
            return new int[]{(int)valueOffset};
        }
        return this.readIntValues(iis, valueOffset, valuesCount);
    }

    private int[] readShortValues(ImageInputStream iis, int valuesCount) throws IOException {
        if (valuesCount <= 2) {
            int[] buffer = new int[valuesCount];
            for (int i = 0; i < valuesCount; ++i) {
                buffer[i] = iis.readShort();
            }
            iis.skipBytes(4 - valuesCount * 2);
            return buffer;
        }
        long valueOffset = iis.readUnsignedInt();
        return this.readShortValues(iis, valueOffset, valuesCount);
    }

    private int[] readByteValues(ImageInputStream iis, int valuesCount) throws IOException {
        if (valuesCount <= 4) {
            int[] buffer = new int[valuesCount];
            for (int i = 0; i < valuesCount; ++i) {
                buffer[i] = iis.readByte();
            }
            iis.skipBytes(4 - valuesCount);
            return buffer;
        }
        long valueOffset = iis.readUnsignedInt();
        return this.readByteValues(iis, valueOffset, valuesCount);
    }

    private byte[] readUndefinedValues(ImageInputStream iis, int valuesCount) throws IOException {
        byte[] buffer = new byte[valuesCount];
        if (valuesCount <= 4) {
            for (int i = 0; i < valuesCount; ++i) {
                buffer[i] = iis.readByte();
            }
            iis.skipBytes(4 - valuesCount);
        } else {
            this.valueOffset = iis.readUnsignedInt();
            iis.mark();
            iis.seek(this.valueOffset);
            iis.readFully(buffer);
            iis.reset();
        }
        return buffer;
    }

    static {
        TIFFTag.typeToString[0] = "0";
        TIFFTag.typeToString[1] = "byte";
        TIFFTag.typeToString[2] = "ascii";
        TIFFTag.typeToString[3] = "short";
        TIFFTag.typeToString[4] = "long";
        TIFFTag.typeToString[5] = "rational";
        TIFFTag.typeToString[6] = "signed byte";
        TIFFTag.typeToString[7] = "undefined";
        TIFFTag.typeToString[8] = "signed short";
        TIFFTag.typeToString[9] = "signed long";
        TIFFTag.typeToString[10] = "signed rational";
        TIFFTag.typeToString[11] = "signed float";
        TIFFTag.typeToString[12] = "double";
        TIFFTag.typeToString[13] = "orf13";
    }
}

