/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.tiff;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.util.Logger;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class ThumbnailHelper {
    private static final String CLASS = ThumbnailHelper.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    @Nonnull
    public final IFD ifd;
    private int width;
    private int height;
    private int offset;
    private int byteCount;
    private byte[] buffer;

    public ThumbnailHelper(@Nonnull RAWImageInputStream iis, @Nonnull IFD ifd) {
        this.ifd = ifd;
        if (ifd.isImageWidthAvailable()) {
            this.width = ifd.getImageWidth();
            this.height = ifd.getImageLength();
        } else {
            this.offset = ifd.getJPEGInterchangeFormat();
            this.byteCount = ifd.getJPEGInterchangeFormatLength();
            this.getSizeFromEmbeddedJPEG(iis);
        }
        if (ifd.isJPEGInterchangeFormatAvailable()) {
            this.offset = ifd.getJPEGInterchangeFormat();
            this.byteCount = ifd.getJPEGInterchangeFormatLength();
        }
        if (ifd.isStripOffsetsAvailable()) {
            this.offset = ifd.getStripOffsets();
            this.byteCount = ifd.getStripByteCounts();
        }
    }

    public ThumbnailHelper(@Nonnull RAWImageInputStream iis, int offset, @Nonnegative int byteCount) {
        this.ifd = null;
        this.offset = offset;
        this.byteCount = byteCount;
        this.getSizeFromEmbeddedJPEG(iis);
    }

    public ThumbnailHelper(@Nonnull RAWImageInputStream iis, @Nonnull byte[] buffer) {
        this.ifd = null;
        this.buffer = buffer;
        this.getSizeFromEmbeddedJPEG(iis);
    }

    public ThumbnailHelper(@Nonnull RAWImageInputStream iis, int offset, @Nonnegative int byteCount, int width, int height) {
        this.ifd = null;
        this.offset = offset;
        this.byteCount = byteCount;
        this.width = width;
        this.height = height;
    }

    @Nonnegative
    public int getWidth() {
        return this.width;
    }

    @Nonnegative
    public int getHeight() {
        return this.height;
    }

    @Nonnull
    public BufferedImage load(@Nonnull ImageInputStream iis) throws IOException {
        logger.fine("load(%s)", iis);
        byte[] buffer = this.getBuffer(iis);
        BufferedImage image = ImageIO.read(this.createInputStream(buffer));
        if (image == null) {
            image = this.loadPlainImage(iis, this.width, this.height, this.offset, this.byteCount);
        }
        return image;
    }

    @Nonnull
    private byte[] getBuffer(@Nonnull ImageInputStream iis) throws IOException {
        if (this.buffer != null) {
            return this.buffer;
        }
        byte[] buffer = new byte[this.byteCount];
        iis.seek(this.offset);
        iis.readFully(buffer);
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSizeFromEmbeddedJPEG(@Nonnull RAWImageInputStream iis) {
        ImageInputStream is = null;
        ImageReader ir = null;
        try {
            long save = iis.getStreamPosition();
            byte[] buffer = this.getBuffer(iis);
            int b0 = buffer[0] & 0xFF;
            int b1 = buffer[1] & 0xFF;
            int magic = b0 << 8 | b1;
            if (magic != 65496 && magic != 728) {
                logger.warning("Ignoring thumbnail JPEG, starts with 0x%04x", magic);
            } else {
                ir = ImageIO.getImageReadersByFormatName("JPEG").next();
                is = ImageIO.createImageInputStream(this.createInputStream(buffer));
                ir.setInput(is);
                this.width = ir.getWidth(0);
                this.height = ir.getHeight(0);
                iis.seek(save);
            }
        }
        catch (IOException e) {
            logger.throwing(CLASS, "getSizeFromEmbeddedJPEG()", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.warning("While closing stream " + e, new Object[0]);
                }
            }
            if (ir != null) {
                ir.dispose();
            }
        }
    }

    @Nonnull
    protected InputStream createInputStream(@Nonnull byte[] buffer) {
        return new ByteArrayInputStream(buffer);
    }

    protected BufferedImage loadPlainImage(@Nonnull ImageInputStream iis, @Nonnull int width, @Nonnull int height, int offset, @Nonnegative int length) throws IOException {
        int pixelStride = 3;
        int scanlineStride = 3 * width;
        int[] bandOffsets = new int[]{0, 1, 2};
        WritableRaster raster = Raster.createInterleavedRaster(0, width, height, scanlineStride, 3, bandOffsets, null);
        iis.seek(offset);
        DataBufferByte dataBuffer = (DataBufferByte)raster.getDataBuffer();
        iis.readFully(dataBuffer.getData(), 0, scanlineStride * height);
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        ComponentColorModel colorModel = new ComponentColorModel(colorSpace, false, false, 1, 0);
        Properties properties = new Properties();
        BufferedImage bufferedImage = new BufferedImage(colorModel, raster, false, properties);
        return bufferedImage;
    }
}

