/*
 * Decompiled with CFR 0.152.
 */
package com.day.util;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TimeZone;
import java.util.Vector;

public class TimeZoneUtil {
    private static TimeZone[] zones = null;
    private static final DecimalFormat offsetFormatter = new DecimalFormat("00.00");

    public static synchronized TimeZone[] getAvailableZones() {
        if (zones == null) {
            String[] allZones = TimeZone.getAvailableIDs();
            Vector<TimeZone> uniqueZones = new Vector<TimeZone>();
            for (int i = 0; i < allZones.length; ++i) {
                if (allZones[i].length() <= 3 && !allZones[i].equals("UTC")) continue;
                TimeZone zone = TimeZone.getTimeZone(allZones[i]);
                uniqueZones.add(zone);
            }
            zones = new TimeZone[0];
            zones = uniqueZones.toArray(zones);
            Arrays.sort(zones, new TimeZoneComparator());
        }
        TimeZone[] retVal = new TimeZone[zones.length];
        System.arraycopy(zones, 0, retVal, 0, zones.length);
        return retVal;
    }

    public static TimeZone getServerTimeZone() {
        return TimeZone.getDefault();
    }

    public static String getDisplayName(TimeZone zone) {
        StringBuffer buffer = new StringBuffer("[UTC");
        if (zone.getRawOffset() >= 0) {
            buffer.append("+");
        }
        buffer.append(offsetFormatter.format((double)zone.getRawOffset() / 3600000.0));
        buffer.append("] ").append(zone.getID());
        buffer.append(" (").append(zone.getDisplayName(true, 0));
        buffer.append(")");
        return buffer.toString();
    }

    static class TimeZoneComparator
    implements Comparator {
        TimeZoneComparator() {
        }

        public int compare(Object o1, Object o2) {
            int diff = ((TimeZone)o1).getRawOffset() - ((TimeZone)o2).getRawOffset();
            return diff != 0 ? diff : ((TimeZone)o1).getID().compareTo(((TimeZone)o2).getID());
        }
    }
}

