/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb;

import com.day.smb.SmbException;
import com.day.smb.SmbHeader;
import com.day.smb.SmbInput;
import com.day.smb.SmbOutput;
import com.day.smb.Util;
import com.day.smb.ntlm.NTLM;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;

public class SmbClient {
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    private static final int SMB_PORT = 445;
    private static final int DEFAULT_MULTIPLEX_ID = 1;
    private static final String CLIENT_OS = "Windows 5.0";
    private static final String CLIENT_LANMAN = "Windows 2000 LAN Manager";
    private static int processIDCounter;
    private final InetAddress server;
    private final int processID;
    private Socket socket;
    private InputStream in;
    private OutputStream out;

    public SmbClient(InetAddress server) {
        this.server = server;
        this.processID = ++processIDCounter;
    }

    protected Socket createSocket() throws SmbException {
        Socket socket = null;
        boolean successful = false;
        try {
            socket = new Socket(this.server, 445);
            successful = true;
            Socket socket2 = socket;
            return socket2;
        }
        catch (SocketException e) {
            String msg = "Unable to create socket.";
            throw new SmbException(msg);
        }
        catch (IOException e) {
            String msg = "I/O error while creating socket.";
            throw new SmbException(msg);
        }
        finally {
            if (!successful && socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public byte[] negotiate() throws SmbException {
        byte[] res;
        this.connect();
        SmbOutput smbOut = new SmbOutput();
        SmbHeader hdr = new SmbHeader();
        hdr.setCommand(114);
        hdr.setFlags(8);
        hdr.setFlags2(16385);
        hdr.setPid(this.processID);
        hdr.setMid(1);
        hdr.write(smbOut);
        smbOut.writeByte(0);
        smbOut.writeShort(1 + "NT LM 0.12".length() + 1);
        smbOut.writeByte(2);
        smbOut.writeASCII("NT LM 0.12");
        try {
            OutputStream out = this.getOutputStream();
            Util.writeInt(out, smbOut.getLength());
            out.write(smbOut.getByteArray(), 0, smbOut.getLength());
            out.flush();
        }
        catch (IOException e) {
            String msg = "Unable to send negotiate request.";
            throw new SmbException(msg, e);
        }
        try {
            InputStream in = this.getInputStream();
            res = new byte[Util.readInt(in)];
            Util.readFully(in, res);
        }
        catch (IOException e) {
            String msg = "Unable to receive negotiate response.";
            throw new SmbException(msg, e);
        }
        SmbInput smbIn = new SmbInput(res);
        hdr = new SmbHeader();
        hdr.read(smbIn);
        if (hdr.getStatus() != 0) {
            String msg = "NEGOTIATE failed: " + Integer.toHexString(hdr.getStatus());
            throw new SmbException(msg);
        }
        smbIn.readUnsignedByte();
        smbIn.readUnsignedShort();
        smbIn.readUnsignedByte();
        smbIn.readUnsignedShort();
        smbIn.readUnsignedShort();
        smbIn.readInt();
        smbIn.readInt();
        smbIn.readInt();
        smbIn.readInt();
        smbIn.readLong();
        smbIn.readUnsignedShort();
        int encryptionKeyLength = smbIn.readUnsignedByte();
        smbIn.readUnsignedShort();
        return smbIn.readFully(encryptionKeyLength);
    }

    public void setup(String username, String domain, byte[] response) throws SmbException {
        byte[] res;
        SmbOutput smbOut = new SmbOutput();
        SmbHeader hdr = new SmbHeader();
        hdr.setCommand(115);
        hdr.setFlags(8);
        hdr.setFlags2(16385);
        hdr.setPid(this.processID);
        hdr.setMid(1);
        hdr.write(smbOut);
        SmbOutput paramsOut = new SmbOutput();
        paramsOut.writeByte(255);
        paramsOut.writeByte(0);
        paramsOut.writeShort(0);
        paramsOut.writeShort(65535);
        paramsOut.writeShort(2);
        paramsOut.writeShort(1);
        paramsOut.writeInt(0);
        paramsOut.writeShort(response.length);
        paramsOut.writeShort(response.length);
        paramsOut.writeInt(0);
        paramsOut.writeInt(68);
        smbOut.writeByte(paramsOut.getLength() / 2);
        smbOut.append(paramsOut);
        SmbOutput dataOut = new SmbOutput();
        dataOut.write(response);
        dataOut.write(response);
        dataOut.writeString(username);
        dataOut.writeString(domain);
        dataOut.writeString(CLIENT_OS);
        dataOut.writeString(CLIENT_LANMAN);
        smbOut.writeShort(dataOut.getLength());
        smbOut.append(dataOut);
        try {
            OutputStream out = this.getOutputStream();
            Util.writeInt(out, smbOut.getLength());
            out.write(smbOut.getByteArray(), 0, smbOut.getLength());
            out.flush();
        }
        catch (IOException e) {
            String msg = "Unable to send session setup request.";
            throw new SmbException(msg, e);
        }
        try {
            InputStream in = this.getInputStream();
            res = new byte[Util.readInt(in)];
            Util.readFully(in, res);
        }
        catch (IOException e) {
            String msg = "Unable to receive session setup response.";
            throw new SmbException(msg, e);
        }
        SmbInput smbIn = new SmbInput(res);
        hdr = new SmbHeader();
        hdr.read(smbIn);
        if (hdr.getStatus() != 0) {
            String msg = "SESSION_SETUP_ANDX failed: " + Integer.toHexString(hdr.getStatus());
            throw new SmbException(msg);
        }
    }

    public void close() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.out = null;
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.in = null;
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
    }

    private void connect() throws SmbException {
        if (this.socket == null) {
            this.socket = this.createSocket();
        }
    }

    private InputStream getInputStream() throws IOException {
        if (this.in == null) {
            this.in = this.socket.getInputStream();
        }
        return this.in;
    }

    private OutputStream getOutputStream() throws IOException {
        if (this.out == null) {
            this.out = this.socket.getOutputStream();
        }
        return this.out;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.err.println("Usage: server domain username");
            System.exit(1);
        }
        String server = args[0];
        String domain = args[1];
        String username = args[2];
        SmbClient client = new SmbClient(InetAddress.getByName(server));
        byte[] challenge = client.negotiate();
        System.out.print("Challenge: ");
        System.out.println(Util.toHexString(challenge));
        System.out.print("Password: ");
        String password = SmbClient.readLine(System.in);
        byte[] response = NTLM.getNTLMResponse(password, challenge);
        System.out.print("Response: ");
        System.out.println(Util.toHexString(response));
        client.setup(username, domain, response);
    }

    /*
     * Unable to fully structure code
     */
    private static String readLine(InputStream in) throws Exception {
        line = new StringBuffer(80);
        data = new byte[80];
        block0: while (true) {
            if ((len = in.read(data)) <= 0) {
                continue;
            }
            i = 0;
            while (true) {
                if (i < data.length) ** break;
                continue block0;
                n = data[i];
                if (n == 13 || n == 10) {
                    return line.toString();
                }
                line.append((char)n);
                ++i;
            }
            break;
        }
    }
}

