/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb;

import com.day.smb.SmbException;
import com.day.smb.SmbInput;
import com.day.smb.SmbOutput;
import com.day.smb.Util;
import java.util.Arrays;

public class SmbHeader {
    public static final int LENGTH = 32;
    public static final int MINIMAL_LENGTH = 34;
    public static final int MAXIMAL_LENGTH = 65535;
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    public static final byte[] SMB_IDENTIFIER = new byte[]{-1, 83, 77, 66};
    private final int EXTRA_LEN = 12;
    private final byte[] protocol = new byte[SMB_IDENTIFIER.length];
    private int command;
    private int status;
    private int flags;
    private int flags2;
    private final byte[] extra = new byte[12];
    private int tid;
    private int pid;
    private int uid;
    private int mid;

    public SmbHeader(SmbHeader client) {
        this.command = client.getCommand();
        this.tid = client.getTid();
        this.pid = client.getPid();
        this.uid = client.getUid();
        this.mid = client.getMid();
    }

    public SmbHeader() {
    }

    public void read(SmbInput in) throws SmbException {
        in.readFully(this.protocol);
        if (!Arrays.equals(this.protocol, SMB_IDENTIFIER)) {
            String msg = "Expected protocol: " + Util.toHexString(SMB_IDENTIFIER) + ", received: " + Util.toHexString(this.protocol);
            throw new SmbException(msg);
        }
        this.command = in.readUnsignedByte();
        this.status = in.readInt();
        this.flags = in.readUnsignedByte();
        this.flags2 = in.readUnsignedShort();
        in.readFully(this.extra);
        this.tid = in.readUnsignedShort();
        this.pid = in.readUnsignedShort();
        this.uid = in.readUnsignedShort();
        this.mid = in.readUnsignedShort();
    }

    public void write(SmbOutput out) {
        out.write(SMB_IDENTIFIER);
        out.writeByte(this.command);
        out.writeInt(this.status);
        out.writeByte(this.flags);
        out.writeShort(this.flags2);
        out.write(this.extra);
        out.writeShort(this.tid);
        out.writeShort(this.pid);
        out.writeShort(this.uid);
        out.writeShort(this.mid);
    }

    public byte[] getProtocol() {
        return this.protocol;
    }

    public int getCommand() {
        return this.command;
    }

    public void setCommand(int command) {
        this.command = command;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public int getFlags2() {
        return this.flags2;
    }

    public void setFlags2(int flags2) {
        this.flags2 = flags2;
    }

    public int getTid() {
        return this.tid;
    }

    public void setTid(int tid) {
        this.tid = tid;
    }

    public int getPid() {
        return this.pid;
    }

    public void setPid(int pid) {
        this.pid = pid;
    }

    public int getUid() {
        return this.uid;
    }

    public void setUid(int uid) {
        this.uid = uid;
    }

    public int getMid() {
        return this.mid;
    }

    public void setMid(int mid) {
        this.mid = mid;
    }

    public boolean isUnicode() {
        return (this.flags2 & 0x8000) != 0;
    }
}

