/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb;

import com.day.smb.InvalidParameterException;
import com.day.smb.SmbException;
import java.io.UnsupportedEncodingException;

public class SmbInput {
    public static final SmbInput NULL = new SmbInput(new byte[0]);
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    private final byte[] data;
    private final int offset;
    private final int length;
    private int position;
    private boolean unicode;

    public SmbInput(byte[] data) {
        this(data, 0, data.length, false);
    }

    public SmbInput(byte[] data, boolean unicode) {
        this(data, 0, data.length, unicode);
    }

    protected SmbInput(byte[] data, int offset, int length, boolean unicode) {
        this.data = data;
        this.offset = offset;
        this.length = length;
        this.unicode = unicode;
    }

    public boolean readBoolean() throws SmbException {
        this.checkAvailable(1);
        return (this.data[this.offset + this.position++] & 0xFF) != 0;
    }

    public int readUnsignedByte() throws SmbException {
        this.checkAvailable(1);
        return this.data[this.offset + this.position++] & 0xFF;
    }

    public int readUnsignedShort() throws SmbException {
        this.checkAvailable(2);
        int ch1 = this.data[this.offset + this.position++] & 0xFF;
        int ch2 = this.data[this.offset + this.position++] & 0xFF;
        return (ch2 << 8) + (ch1 << 0);
    }

    public int readInt() throws SmbException {
        this.checkAvailable(4);
        int ch1 = this.data[this.offset + this.position++] & 0xFF;
        int ch2 = this.data[this.offset + this.position++] & 0xFF;
        int ch3 = this.data[this.offset + this.position++] & 0xFF;
        int ch4 = this.data[this.offset + this.position++] & 0xFF;
        return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + (ch1 << 0);
    }

    public long readLong() throws SmbException {
        this.checkAvailable(8);
        int ch1 = this.data[this.offset + this.position++] & 0xFF;
        int ch2 = this.data[this.offset + this.position++] & 0xFF;
        int ch3 = this.data[this.offset + this.position++] & 0xFF;
        int ch4 = this.data[this.offset + this.position++] & 0xFF;
        long l1 = (long)((ch4 << 24) + (ch3 << 16) + (ch2 << 8) + (ch1 << 0)) & 0xFFFFFFFFL;
        ch1 = this.data[this.offset + this.position++] & 0xFF;
        ch2 = this.data[this.offset + this.position++] & 0xFF;
        ch3 = this.data[this.offset + this.position++] & 0xFF;
        ch4 = this.data[this.offset + this.position++] & 0xFF;
        long l2 = (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + (ch1 << 0);
        return l2 << 32 | l1;
    }

    public void readFully(byte[] buf) throws SmbException {
        this.readFully(buf, 0, buf.length);
    }

    public void readFully(byte[] buf, int off, int len) throws SmbException {
        this.checkAvailable(len);
        System.arraycopy(this.data, this.offset + this.position, buf, off, len);
        this.position += len;
    }

    public byte[] readFully(int n) throws SmbException {
        byte[] buf = new byte[n];
        this.readFully(buf);
        return buf;
    }

    public String readString() throws SmbException {
        if (this.unicode) {
            return this.readUnicode();
        }
        return this.readASCII();
    }

    public String readASCII() throws SmbException {
        for (int index = this.position; index < this.length; ++index) {
            if (this.data[this.offset + index] != 0) continue;
            try {
                String s = new String(this.data, this.offset + this.position, index - this.position, "ASCII");
                this.position = index + 1;
                return s;
            }
            catch (UnsupportedEncodingException e) {
                String msg = "Unable to decode ASCII string.";
                throw new SmbException(msg, e);
            }
        }
        String msg = "No zero-terminated string found.";
        throw new SmbException(msg);
    }

    public String readUnicode() throws SmbException {
        this.align(2);
        for (int index = this.position; index < this.length - 1; index += 2) {
            if (this.data[this.offset + index] != 0 || this.data[this.offset + index + 1] != 0) continue;
            try {
                String s = new String(this.data, this.offset + this.position, index - this.position, "UnicodeLittleUnmarked");
                this.position = index + 2;
                return s;
            }
            catch (UnsupportedEncodingException e) {
                String msg = "Unable to decode Unicode string.";
                throw new SmbException(msg, e);
            }
        }
        String msg = "No zero-terminated string found.";
        throw new SmbException(msg);
    }

    public String readFormatString() throws SmbException {
        int format = this.readUnsignedByte();
        if (format != 4) {
            String msg = "Unexpected format identifier: " + format;
            throw new InvalidParameterException(msg);
        }
        return this.readString();
    }

    public void seek(int position) throws SmbException {
        if (position < 0 || position > this.length) {
            String msg = "Seek position outside range [0," + this.length + "]: " + position;
            throw new SmbException(msg);
        }
        this.position = position;
    }

    public void skip(int n) throws SmbException {
        this.checkAvailable(n);
        this.position += n;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean isEOF() {
        return this.position >= this.length;
    }

    public int available() {
        return this.length - this.position;
    }

    public SmbInput getInput(int length) throws SmbException {
        return this.getInput(this.getPosition(), length);
    }

    public SmbInput getInput(int offset, int length) throws SmbException {
        if (offset < 0 || offset > this.length) {
            String msg = "Offset outside range [0," + this.length + "]: " + offset;
            throw new SmbException(msg);
        }
        if (length < 0 || length > this.length - offset) {
            String msg = "Length outside range [0," + (this.length - offset) + "]: " + length;
            throw new SmbException(msg);
        }
        return new SmbInput(this.data, this.offset + offset, length, this.unicode);
    }

    public boolean isUnicode() {
        return this.unicode;
    }

    public void setUnicode(boolean unicode) {
        this.unicode = unicode;
    }

    private void checkAvailable(int n) throws SmbException {
        if (this.position + n > this.length) {
            String msg = "Not enough data available. Bytes available: " + n + ", requested: " + (this.length - this.position);
            throw new SmbException(msg);
        }
    }

    private void align(int boundary) throws SmbException {
        int rem = (this.offset + this.position) % boundary;
        if (rem != 0) {
            this.skip(boundary - rem);
        }
    }
}

