/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb;

import com.day.smb.SmbException;
import java.io.UnsupportedEncodingException;

public class SmbOutput {
    public static final SmbOutput NULL = new SmbOutput(0){

        public void write(int n) {
        }

        public void write(byte[] buf, int off, int len) {
        }
    };
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    private byte[] data;
    private int position;
    private boolean unicode;
    private int alignment;

    public SmbOutput() {
        this(512);
    }

    public SmbOutput(int initialCapacity) {
        this.data = new byte[initialCapacity];
    }

    public void writeBoolean(boolean b) {
        this.writeByte(b ? 1 : 0);
    }

    public void writeByte(int n) {
        this.write(n);
    }

    public void writeShort(int s) {
        this.write(s >>> 0 & 0xFF);
        this.write(s >>> 8 & 0xFF);
    }

    public void writeInt(int n) {
        this.write(n >>> 0 & 0xFF);
        this.write(n >>> 8 & 0xFF);
        this.write(n >>> 16 & 0xFF);
        this.write(n >>> 24 & 0xFF);
    }

    public void writeLong(long l) {
        this.writeInt((int)(l >>> 0 & 0xFFFFFFFFL));
        this.writeInt((int)(l >>> 32 & 0xFFFFFFFFL));
    }

    public void write(int n) {
        this.ensureCapacity(1);
        this.data[this.position++] = (byte)(n & 0xFF);
    }

    public void write(byte[] buf) {
        this.write(buf, 0, buf.length);
    }

    public void write(byte[] buf, int off, int len) {
        this.ensureCapacity(len);
        System.arraycopy(buf, off, this.data, this.position, len);
        this.position += len;
    }

    public void writeString(String s) throws SmbException {
        if (this.unicode) {
            this.writeUnicode(s);
        } else {
            this.writeASCII(s);
        }
    }

    public void writeASCII(String s) throws SmbException {
        try {
            this.write(s.getBytes("ASCII"));
            this.write(0);
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Unable to encode ASCII string.";
            throw new SmbException(msg, e);
        }
    }

    public void writeUnicode(String s) throws SmbException {
        this.align(2);
        try {
            this.write(s.getBytes("UnicodeLittleUnmarked"));
            this.writeShort(0);
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Unable to encode Unicode string.";
            throw new SmbException(msg, e);
        }
    }

    public void writeWideChars(String s) throws SmbException {
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            this.writeShort(chars[i]);
        }
    }

    public void append(SmbOutput output) {
        this.write(output.data, 0, output.position);
    }

    public void append(SmbOutput output, int offset, int length) {
        if (offset < 0 || offset > output.position) {
            String msg = "Offset outside range [0," + output.position + "]: " + offset;
            throw new IllegalArgumentException(msg);
        }
        if (length < 0 || length > output.position - offset) {
            String msg = "Length outside range [0," + (output.position - offset) + "]: " + length;
            throw new IllegalArgumentException(msg);
        }
        this.write(output.data, offset, length);
    }

    public byte[] getByteArray() {
        return this.data;
    }

    public int getLength() {
        return this.position;
    }

    public byte[] toByteArray() {
        byte[] b = new byte[this.getLength()];
        System.arraycopy(this.data, 0, b, 0, b.length);
        return b;
    }

    private void ensureCapacity(int n) {
        if (this.position + n > this.data.length) {
            if (n < 512) {
                n = 512;
            }
            byte[] tmp = new byte[this.data.length + n];
            System.arraycopy(this.data, 0, tmp, 0, this.position);
            this.data = tmp;
        }
    }

    public boolean isUnicode() {
        return this.unicode;
    }

    public void setUnicode(boolean unicode) {
        this.unicode = unicode;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void align(int boundary) {
        int rem = (this.alignment + this.position) % boundary;
        if (rem != 0) {
            this.ensureCapacity(rem);
            this.position += rem;
        }
    }
}

