/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Util {
    static final String CVS_ID = "$URL$ $Rev$ $Date$";

    public static void print(byte[] data) {
        Util.print(data, 0, data.length);
    }

    public static void print(byte[] data, int offset, int length) {
        for (int address = 0; address < length; address += 16) {
            int i;
            Util.print(address);
            Util.print("  ");
            int linelen = Math.min(length - address, 16);
            for (i = 0; i < linelen; ++i) {
                Util.print(data[offset + address + i]);
                Util.print(" ");
            }
            for (i = linelen; i < 16; ++i) {
                Util.print("   ");
            }
            Util.print("  ");
            for (i = 0; i < linelen; ++i) {
                Util.print((char)data[offset + address + i]);
            }
            Util.print("\n");
        }
    }

    public static void print(int n) {
        String s = Integer.toHexString(n);
        if (s.length() < 8) {
            Util.print("00000000".substring(s.length()));
        }
        Util.print(s);
    }

    public static void print(byte b) {
        String s = Integer.toHexString(b & 0xFF);
        if (s.length() < 2) {
            Util.print("00".substring(2 - s.length()));
        }
        Util.print(s);
    }

    public static void print(char c) {
        if (c >= ' ' && c <= '\u007f') {
            Util.print("" + c);
        } else {
            Util.print(".");
        }
    }

    public static void print(String s) {
        System.out.print(s);
    }

    public static String toHexString(byte[] b) {
        if (b == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            String s = Integer.toHexString(b[i] & 0xFF).toUpperCase();
            if (s.length() == 1) {
                buf.append('0');
            }
            buf.append(s);
        }
        return buf.toString();
    }

    public static int readInt(InputStream in) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
            String msg = "Not enough bytes to read an integer.";
            throw new EOFException(msg);
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public static void readFully(InputStream in, byte[] b) throws IOException {
        int count;
        for (int offset = 0; offset < b.length; offset += count) {
            count = in.read(b, offset, b.length - offset);
            if (count >= 0) continue;
            String msg = "Expected a stream of " + b.length + " bytes, got: " + offset;
            throw new EOFException(msg);
        }
    }

    public static void writeInt(OutputStream out, int n) throws IOException {
        out.write(n >>> 24 & 0xFF);
        out.write(n >>> 16 & 0xFF);
        out.write(n >>> 8 & 0xFF);
        out.write(n >>> 0 & 0xFF);
    }
}

