/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.asn1;

import com.day.smb.SmbException;
import com.day.smb.SmbInput;
import com.day.smb.SmbOutput;
import com.day.smb.asn1.Tag;
import com.day.smb.asn1.TagFactory;
import java.util.Iterator;

abstract class CompositeTag
extends Tag {
    static final String CVS_ID = "$URL$ $Rev$ $Date$";

    protected CompositeTag(int identifier) {
        super(identifier);
    }

    protected void readBody(SmbInput input) throws SmbException {
        int end = input.getPosition() + this.getLength();
        while (input.getPosition() < end) {
            int identifier = input.readUnsignedByte();
            Tag tag = TagFactory.createInstance(identifier);
            tag.read(input);
            this.add(tag);
        }
    }

    protected void writeBody(SmbOutput output) throws SmbException {
        Iterator iter = this.getChildren();
        while (iter.hasNext()) {
            Tag tag = (Tag)iter.next();
            tag.write(output);
        }
    }

    public int getLength() {
        int length = 0;
        Iterator iter = this.getChildren();
        while (iter.hasNext()) {
            Tag tag = (Tag)iter.next();
            length += tag.getOuterLength();
        }
        return length;
    }

    protected abstract String getStringIdentifier();

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(this.getStringIdentifier());
        b.append(" {\n");
        Iterator iter = this.getChildren();
        while (iter.hasNext()) {
            b.append(iter.next());
            b.append('\n');
        }
        b.append("}");
        return b.toString();
    }
}

