/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.asn1;

import com.day.smb.SmbException;
import com.day.smb.SmbInput;
import com.day.smb.SmbOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class Tag {
    public static final int BOOLEAN = 1;
    public static final int INTEGER = 2;
    public static final int BITFIELD = 3;
    public static final int OCTET_STRING = 4;
    public static final int OID = 6;
    public static final int ENUMERATED = 10;
    public static final int GENERAL_STRING = 27;
    public static final int SEQUENCE = 48;
    public static final int APPLICATION_SIMPLE = 64;
    public static final int APPLICATION = 96;
    public static final int CONTEXT_SIMPLE = 128;
    public static final int CONTEXT = 160;
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    private final int identifier;
    private Tag parent;
    private int length;
    private int end;
    private List children;

    protected Tag(int identifier) {
        this.identifier = identifier;
    }

    public void read(SmbInput input) throws SmbException {
        this.readStart(input);
        this.readBody(input);
        this.finish(input);
    }

    protected void readStart(SmbInput input) throws SmbException {
        int length = input.readUnsignedByte();
        if ((length & 0x80) != 0) {
            int bytes = length & 0x7F;
            length = 0;
            for (int i = 0; i < bytes; ++i) {
                length <<= 8;
                length += input.readUnsignedByte();
            }
        }
        this.length = length;
        this.end = input.getPosition() + length;
    }

    protected void readBody(SmbInput input) throws SmbException {
    }

    protected void finish(SmbInput input) throws SmbException {
        input.seek(this.end);
    }

    public void write(SmbOutput output) throws SmbException {
        this.writeStart(output);
        this.writeBody(output);
    }

    protected void writeStart(SmbOutput output) throws SmbException {
        output.writeByte(this.identifier);
        Tag.writeLength(this.getLength(), output);
    }

    protected void writeBody(SmbOutput output) throws SmbException {
    }

    public void add(Tag tag) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(tag);
        tag.setParent(this);
    }

    public Tag getParent() {
        return this.parent;
    }

    protected void setParent(Tag parent) {
        this.parent = parent;
    }

    public Iterator getChildren() {
        if (this.children == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.children.iterator();
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public int getLength() {
        return this.length;
    }

    public int getOuterLength() {
        int length = this.getLength();
        return 1 + Tag.getRequiredBytes(length) + length;
    }

    private static int getRequiredBytes(int length) {
        int bytes = 1;
        if (length > 127) {
            do {
                ++bytes;
            } while ((length >>>= 8) > 0);
        }
        return bytes;
    }

    private static void writeLength(int length, SmbOutput output) {
        int bytes = Tag.getRequiredBytes(length);
        if (bytes > 1) {
            output.writeByte(128 + bytes);
        }
        do {
            output.writeByte(length & 0xFF);
        } while ((length >>>= 8) > 0);
    }
}

