/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.asn1;

import com.day.smb.asn1.ApplicationTag;
import com.day.smb.asn1.ContextTag;
import com.day.smb.asn1.EnumeratedTag;
import com.day.smb.asn1.GeneralString;
import com.day.smb.asn1.OID;
import com.day.smb.asn1.OctetString;
import com.day.smb.asn1.SequenceTag;
import com.day.smb.asn1.Tag;
import com.day.smb.asn1.UnknownTag;

public abstract class TagFactory {
    static final String CVS_ID = "$URL$ $Rev$ $Date$";

    public static Tag createInstance(int identifier) {
        Tag tag = null;
        if (identifier >= 48) {
            switch (identifier & 0xF0) {
                case 96: {
                    tag = new ApplicationTag(identifier);
                    break;
                }
                case 160: {
                    tag = new ContextTag(identifier);
                    break;
                }
                case 48: {
                    tag = new SequenceTag(identifier);
                }
            }
        } else {
            switch (identifier) {
                case 10: {
                    tag = new EnumeratedTag();
                    break;
                }
                case 6: {
                    tag = new OID();
                    break;
                }
                case 4: {
                    tag = new OctetString();
                    break;
                }
                case 27: {
                    tag = new GeneralString();
                }
            }
        }
        if (tag == null) {
            tag = new UnknownTag(identifier);
        }
        return tag;
    }
}

