/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.fs;

import com.day.smb.SmbException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

class FileSystemFile
implements com.day.smb.spi.File {
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    private final File osFile;

    public FileSystemFile(File osFile) {
        this.osFile = osFile;
    }

    public String getName() {
        return this.osFile.getName();
    }

    public boolean isFile() {
        return this.osFile.isFile();
    }

    public boolean isDirectory() {
        return this.osFile.isDirectory();
    }

    public long length() {
        return this.osFile.length();
    }

    public long lastModified() {
        return this.osFile.lastModified();
    }

    public int read(byte[] data, int position) throws SmbException {
        RandomAccessFile raf = null;
        try {
            int len;
            raf = new RandomAccessFile(this.osFile, "r");
            raf.seek(position);
            int total = 0;
            while ((len = raf.read(data, total, data.length - total)) > 0) {
                total += len;
            }
            int n = total;
            return n;
        }
        catch (IOException e) {
            throw new SmbException(e.getMessage());
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void write(byte[] data, int position) throws SmbException {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(this.osFile, "rw");
            raf.seek(position);
            raf.write(data);
        }
        catch (IOException e) {
            throw new SmbException(e.getMessage());
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void setLength(int length) throws SmbException {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(this.osFile, "rw");
            raf.setLength(length);
        }
        catch (IOException e) {
            throw new SmbException(e.getMessage());
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void flush() {
    }

    public boolean delete() {
        return this.osFile.delete();
    }

    public void close() {
    }
}

