/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.fs;

import com.day.smb.ObjectNameNotFoundException;
import com.day.smb.SmbException;
import com.day.smb.fs.FileSystemFile;
import com.day.smb.fs.FileSystemShare;
import com.day.smb.spi.Share;
import com.day.smb.spi.Tree;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;

class FileSystemTree
implements Tree {
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    private final FileSystemShare share;
    private final File root;

    public FileSystemTree(FileSystemShare share, File root) {
        this.share = share;
        this.root = root;
    }

    public com.day.smb.spi.File open(String name) throws SmbException {
        File osFile = this.getFile(name);
        if (!osFile.exists()) {
            String msg = "File not found: " + name;
            throw new ObjectNameNotFoundException(msg);
        }
        return new FileSystemFile(osFile);
    }

    public boolean createFile(String name) throws SmbException {
        try {
            return this.getFile(name).createNewFile();
        }
        catch (IOException e) {
            throw new SmbException(e.getMessage());
        }
    }

    public boolean createDirectory(String name) {
        return this.getFile(name).mkdirs();
    }

    public boolean delete(String name) {
        return this.getFile(name).delete();
    }

    public boolean exists(String name) {
        return this.getFile(name).exists();
    }

    public com.day.smb.spi.File[] list(String pattern) {
        String nameToMatch;
        FilenameFilter filter;
        File[] osFiles;
        File parent = this.root;
        int sepIndex = pattern.lastIndexOf(47);
        if (sepIndex != -1) {
            parent = new File(parent, pattern.substring(0, sepIndex));
            pattern = pattern.substring(sepIndex + 1);
        }
        if ((osFiles = parent.listFiles(filter = new FilenameFilter(nameToMatch = pattern){
            private final /* synthetic */ String val$nameToMatch;
            {
                this.val$nameToMatch = string;
            }

            public boolean accept(File dir, String name) {
                if (name.startsWith("@")) {
                    return false;
                }
                if (this.val$nameToMatch.equals("*")) {
                    return true;
                }
                if (this.val$nameToMatch.endsWith("*")) {
                    String prefix = this.val$nameToMatch.substring(0, this.val$nameToMatch.length() - 1);
                    if (name.length() < prefix.length()) {
                        return false;
                    }
                    name = name.substring(0, prefix.length());
                    return name.equalsIgnoreCase(prefix);
                }
                return name.equals(this.val$nameToMatch);
            }
        })) == null) {
            osFiles = new File[]{};
        }
        com.day.smb.spi.File[] files = new FileSystemFile[osFiles.length];
        for (int i = 0; i < osFiles.length; ++i) {
            files[i] = new FileSystemFile(osFiles[i]);
        }
        return files;
    }

    public boolean rename(String oldName, String newName) {
        return this.getFile(oldName).renameTo(this.getFile(newName));
    }

    public Share getShare() {
        return this.share;
    }

    public void flush() {
    }

    public void disconnect() {
    }

    private File getFile(String name) {
        return new File(this.root, name);
    }
}

