/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.netbios;

import com.day.smb.netbios.NBException;
import com.day.smb.netbios.NBInput;
import com.day.smb.netbios.NBOutput;

public class Header {
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    private int transactionId;
    private int flags;
    private int questions;
    private int answerRR;
    private int authorityRR;
    private int additionalRR;

    protected Header() {
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(int transactionId) {
        this.transactionId = transactionId;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean isResponse() {
        return (this.flags & 0x8000) != 0;
    }

    public int getReturnCode() {
        return this.flags & 0xF;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public int getQuestions() {
        return this.questions;
    }

    public void setQuestions(int questions) {
        this.questions = questions;
    }

    public int getAnswerRR() {
        return this.answerRR;
    }

    public void setAnswerRR(int answerRR) {
        this.answerRR = answerRR;
    }

    public int getAuthorityRR() {
        return this.authorityRR;
    }

    public void setAuthorityRR(int authorityRR) {
        this.authorityRR = authorityRR;
    }

    public int getAdditionalRR() {
        return this.additionalRR;
    }

    public void setAdditionalRR(int additionalRR) {
        this.additionalRR = additionalRR;
    }

    public void read(NBInput in) throws NBException {
        this.transactionId = in.readUnsignedShort();
        this.flags = in.readUnsignedShort();
        this.questions = in.readUnsignedShort();
        this.answerRR = in.readUnsignedShort();
        this.authorityRR = in.readUnsignedShort();
        this.additionalRR = in.readUnsignedShort();
    }

    public void write(NBOutput out) throws NBException {
        out.writeShort(this.transactionId);
        out.writeShort(this.flags);
        out.writeShort(this.questions);
        out.writeShort(this.answerRR);
        out.writeShort(this.authorityRR);
        out.writeShort(this.additionalRR);
    }
}

